/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input;

import net.minecraft.client.Minecraft;
import net.minecraft.client.input.InputType;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.input.glfw.GlfwGamepad;
import net.minecraft.client.input.glfw.GlfwJoystick;
import org.lwjgl.glfw.GLFW;

public abstract class InputHandler {
    private static Minecraft minecraft;
    public static ControllerInput[] controllers;

    public static void init(Minecraft minecraft) throws Exception {
        InputHandler.minecraft = minecraft;
        try {
            InputHandler.initLWJGL3(minecraft);
        }
        catch (Throwable e) {
            System.err.println("Could not initialize LWJGL3.");
            e.printStackTrace();
        }
    }

    public static void poll() {
        for (int i = 0; i < 15; ++i) {
            ControllerInput input;
            GlfwGamepad gamepad;
            if (controllers[i] != null) {
                if (!controllers[i].getController().isPresent()) {
                    InputHandler.disconnected(controllers[i]);
                    InputHandler.controllers[i] = null;
                    continue;
                }
                controllers[i].getController().poll();
                continue;
            }
            if (!GLFW.glfwJoystickPresent((int)i) || (gamepad = new GlfwJoystick(i).intoGamepad()) == null) continue;
            InputHandler.controllers[i] = input = new ControllerInput(minecraft, gamepad);
            InputHandler.connected(input);
        }
    }

    private static void connected(ControllerInput controller) {
        System.out.println("Controller connected: " + controller.getGUID());
        InputHandler.minecraft.controllerInput = InputHandler.getController(controller.getGUID());
    }

    private static void disconnected(ControllerInput controller) {
        System.out.println("Controller disconnected: " + controller.getGUID());
        if (InputHandler.minecraft.controllerInput == controller) {
            minecraft.setInputType(InputType.KEYBOARD);
            InputHandler.minecraft.controllerInput = null;
        }
    }

    public static void initLWJGL3(Minecraft minecraft) throws Throwable {
        int found = 0;
        for (int i = 0; i < 15; ++i) {
            ControllerInput input;
            GlfwGamepad gamepad;
            if (!GLFW.glfwJoystickPresent((int)i) || (gamepad = new GlfwJoystick(i).intoGamepad()) == null) continue;
            InputHandler.controllers[i] = input = new ControllerInput(minecraft, gamepad);
            ++found;
        }
        System.out.println(found + " controllers found!");
    }

    public static ControllerInput getController(String guid) {
        try {
            for (ControllerInput controllerInput : controllers) {
                if (!controllerInput.getGUID().equalsIgnoreCase(guid)) continue;
                return controllerInput;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        controllers = new ControllerInput[16];
    }
}

