/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input.controller;

import net.minecraft.client.input.controller.ControllerTypeDatabase;
import net.minecraft.client.input.glfw.GlfwGamepad;

public enum ControllerType {
    UNKNOWN(Layout.XBOX, "xbox_360", "UNKNOWN"),
    XBOX_360(Layout.XBOX, "xbox_360", "XBOX 360"),
    XBOX_ONE(Layout.XBOX, "xbox_one", "XBOX ONE"),
    PS3(Layout.PLAYSTATION, "ps3", "PLAYSTATION 3"),
    PS4(Layout.PLAYSTATION, "ps4", "PLAYSTATION 4"),
    PS5(Layout.PLAYSTATION, "ps5", "PLAYSTATION 5"),
    SWITCH(Layout.NINTENDO, "switch", "NINTENDO SWITCH"),
    STEAM(Layout.XBOX, "steam", "STEAM CONTROLLER"),
    STEAM_DECK(Layout.STEAM_DECK, "steam_deck", "STEAM DECK");

    private final Layout layout;
    private final String assetName;
    private final String printableName;

    private ControllerType(Layout layout, String assetName, String printableName) {
        this.layout = layout;
        this.assetName = assetName;
        this.printableName = printableName;
    }

    public static ControllerType fromController(GlfwGamepad controller) {
        int vid = controller.getVendorId();
        int pid = controller.getDeviceId();
        return ControllerTypeDatabase.getControllerType(vid, pid);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public String getPrintableName() {
        return this.printableName;
    }

    public static enum Layout {
        XBOX,
        PLAYSTATION,
        NINTENDO,
        STEAM_DECK;

    }
}

