/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input.glfw;

import java.nio.ByteBuffer;
import net.minecraft.client.input.glfw.GlfwJoystick;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWGamepadState;

public class GlfwGamepad
extends GlfwJoystick {
    private GLFWGamepadState state = null;

    public GlfwGamepad(int id) {
        super(id);
    }

    @Override
    public void poll() {
        super.poll();
        this.state = new GLFWGamepadState(ByteBuffer.allocateDirect(GLFWGamepadState.SIZEOF));
        GLFW.glfwGetGamepadState((int)this.getId(), (GLFWGamepadState)this.state);
    }

    @Override
    public String getName() {
        return GLFW.glfwGetGamepadName((int)this.getId());
    }

    @Override
    public float getAxisValue(int axis) {
        if (this.state != null && axis >= 0 && axis < this.state.axes().capacity()) {
            return this.state.axes().get(axis);
        }
        return 0.0f;
    }

    @Override
    public boolean isButtonPressed(int button) {
        if (this.state != null && button >= 0 && button < this.state.buttons().capacity()) {
            return this.state.buttons().get(button) == 1;
        }
        return false;
    }

    @Override
    public GlfwGamepad intoGamepad() {
        return this;
    }
}

