/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import net.minecraft.client.option.GameSettings;
import net.minecraft.core.lang.I18n;

public abstract class Option<E> {
    public final GameSettings gameSettings;
    public final String name;
    public E value;
    protected final E defaultValue;

    public Option(GameSettings gameSettings, String name, E defaultValue) {
        this.gameSettings = gameSettings;
        this.name = name;
        this.value = defaultValue;
        this.defaultValue = defaultValue;
        GameSettings.options.add(this);
    }

    public void set(E value) {
        this.value = value;
    }

    public abstract void parse(String var1);

    public void onUpdate() {
        this.gameSettings.optionChanged(this);
    }

    public String getDisplayString() {
        return this.gameSettings.getDisplayString(this);
    }

    public String getDisplayStringValue() {
        return this.gameSettings.getDisplayString(this);
    }

    public String getDisplayStringName() {
        return I18n.getInstance().translateKey("options." + this.name);
    }

    public String getValueString() {
        return this.value.toString();
    }

    public E getDefaultValue() {
        return this.defaultValue;
    }
}

