/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.ChestBlockModel;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.ChestBlock;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public class PaintedChestBlockModel<T extends Block>
extends ChestBlockModel<T> {
    public static final IconCoordinate[][] texCoords = new IconCoordinate[16][];
    public static final int TEX_SINGLE_FRONT = 0;
    public static final int TEX_LEFT_FRONT = 1;
    public static final int TEX_RIGHT_FRONT = 2;
    public static final int TEX_LEFT_BACK = 3;
    public static final int TEX_RIGHT_BACK = 4;
    public static final int TEX_SIDE = 5;
    public static final int TEX_TOP = 6;

    public PaintedChestBlockModel(Block block) {
        super(block, "minecraft:block/chest_planks_oak");
    }

    @Override
    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        int meta = blockAccess.getBlockMetadata(x, y, z);
        int color = meta >> 4;
        if (side == Side.TOP || side == Side.BOTTOM) {
            return texCoords[color][6];
        }
        Side facing = ChestBlock.getDirectionFromMeta(meta).getSide();
        ChestBlock.Type type = ChestBlock.getTypeFromMeta(meta);
        if (type == ChestBlock.Type.SINGLE && side == facing) {
            return texCoords[color][0];
        }
        if (type == ChestBlock.Type.LEFT) {
            if (side == facing) {
                return texCoords[color][1];
            }
            if (side == facing.getOpposite()) {
                return texCoords[color][4];
            }
        }
        if (type == ChestBlock.Type.RIGHT) {
            if (side == facing) {
                return texCoords[color][2];
            }
            if (side == facing.getOpposite()) {
                return texCoords[color][3];
            }
        }
        if (side.getAxis() != Axis.Y) {
            return texCoords[color][5];
        }
        return texCoords[color][6];
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int color = data >> 4;
        if (side == Side.SOUTH) {
            return texCoords[color][0];
        }
        if (side.isHorizontal()) {
            return texCoords[color][5];
        }
        return texCoords[color][6];
    }

    static {
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            String rootKey = "minecraft:block/chest_planks_oak_painted_" + c.colorID;
            PaintedChestBlockModel.texCoords[c.blockMeta] = new IconCoordinate[7];
            PaintedChestBlockModel.texCoords[c.blockMeta][0] = TextureRegistry.getTexture(rootKey + "_front");
            PaintedChestBlockModel.texCoords[c.blockMeta][1] = TextureRegistry.getTexture(rootKey + "_left_front");
            PaintedChestBlockModel.texCoords[c.blockMeta][2] = TextureRegistry.getTexture(rootKey + "_right_front");
            PaintedChestBlockModel.texCoords[c.blockMeta][3] = TextureRegistry.getTexture(rootKey + "_left_back");
            PaintedChestBlockModel.texCoords[c.blockMeta][4] = TextureRegistry.getTexture(rootKey + "_right_back");
            PaintedChestBlockModel.texCoords[c.blockMeta][5] = TextureRegistry.getTexture(rootKey + "_side");
            PaintedChestBlockModel.texCoords[c.blockMeta][6] = TextureRegistry.getTexture(rootKey + "_top");
        }
    }
}

