/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.model.BaseModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.animal.SquidMob;
import org.lwjgl.opengl.GL11;

public class SquidRenderer
extends MobRenderer<SquidMob> {
    public SquidRenderer(BaseModel modelbase, float f) {
        super(modelbase, f);
    }

    @Override
    protected float limbSway(SquidMob squid, float partialTick) {
        return squid.oldTentacleAngle + (squid.tentacleAngle - squid.oldTentacleAngle) * partialTick;
    }

    @Override
    protected void setupRotations(SquidMob squid, float ticksExisted, float bodyYaw, float partialTick) {
        float pitch = squid.xBodyRotO + (squid.xBodyRot - squid.xBodyRotO) * partialTick;
        float yaw = squid.zBodyRotO + (squid.zBodyRot - squid.zBodyRotO) * partialTick;
        GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.0f);
        GL11.glRotatef((float)(180.0f - bodyYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)-1.2f, (float)0.0f);
    }

    @Override
    public void renderPreview(Tessellator tessellator, SquidMob squid, double x, double y, double z, float yaw, float partialTick) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)1.25f, (float)0.0f);
        super.renderPreview(tessellator, squid, x, y, z, yaw, partialTick);
        GL11.glPopMatrix();
    }
}

