/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.render.model.BipedModel;
import net.minecraft.client.render.model.Cube;
import org.lwjgl.opengl.GL11;

public class PlayerModel
extends BipedModel {
    public Cube bipedLeftArmOverlay;
    public Cube bipedRightArmOverlay;
    public Cube bipedLeftLegOverlay;
    public Cube bipedRightLegOverlay;
    public Cube bipedBodyOverlay;

    public PlayerModel(float expansion) {
        this(expansion, 0.0f);
    }

    public PlayerModel(float expansion, float yRotOffset) {
        this.holdingLeftHand = false;
        this.holdingRightHand = false;
        this.sneaking = false;
        this.cloak = new Cube(0, 0, 64, 32);
        this.cloak.addBox(-5.0f, 0.0f, -1.0f, 10, 16, 1, expansion, true);
        this.ear = new Cube(24, 0, 64, 64);
        this.ear.addBox(-3.0f, -6.0f, -1.0f, 6, 6, 1, expansion, true);
        this.bipedLeftArmOverlay = new Cube(48, 48, 64, 64);
        this.bipedLeftArmOverlay.addBox(-1.0f, -2.0f, -2.0f, 4, 12, 4, expansion + 0.25f, true);
        this.bipedLeftArmOverlay.setRotationPoint(5.0f, 2.0f, 0.0f);
        this.bipedRightArmOverlay = new Cube(40, 32, 64, 64);
        this.bipedRightArmOverlay.addBox(-3.0f, -2.0f, -2.0f, 4, 12, 4, expansion + 0.25f, true);
        this.bipedRightArmOverlay.setRotationPoint(-5.0f, 2.0f, 10.0f);
        this.bipedLeftLegOverlay = new Cube(0, 48, 64, 64);
        this.bipedLeftLegOverlay.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, expansion + 0.25f, true);
        this.bipedLeftLegOverlay.setRotationPoint(1.9f, 12.0f, 0.0f);
        this.bipedRightLegOverlay = new Cube(0, 32, 64, 64);
        this.bipedRightLegOverlay.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, expansion + 0.25f, true);
        this.bipedRightLegOverlay.setRotationPoint(-1.9f, 12.0f, 0.0f);
        this.bipedBodyOverlay = new Cube(16, 32, 64, 64);
        this.bipedBodyOverlay.addBox(-4.0f, 0.0f, -2.0f, 8, 12, 4, expansion + 0.25f, true);
        this.bipedBodyOverlay.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.arm1 = new Cube(32, 48, 64, 64);
        this.arm1.addBox(-1.0f, -2.0f, -2.0f, 4, 12, 4, expansion, true);
        this.arm1.setRotationPoint(5.0f, 2.0f, 0.0f);
        this.leg1 = new Cube(16, 48, 64, 64);
        this.leg1.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, expansion, true);
        this.leg1.setRotationPoint(1.9f, 12.0f, 0.0f);
        this.head = new Cube(0, 0, 64, 64);
        this.head.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, expansion, true);
        this.head.setRotationPoint(0.0f, 0.0f + yRotOffset, 0.0f);
        this.hair = new Cube(32, 0, 64, 64);
        this.hair.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, expansion + 0.5f, true);
        this.hair.setRotationPoint(0.0f, 0.0f + yRotOffset, 0.0f);
        this.body = new Cube(16, 16, 64, 64);
        this.body.addBox(-4.0f, 0.0f, -2.0f, 8, 12, 4, expansion, true);
        this.body.setRotationPoint(0.0f, 0.0f + yRotOffset, 0.0f);
        this.arm0 = new Cube(40, 16, 64, 64);
        this.arm0.addBox(-3.0f, -2.0f, -2.0f, 4, 12, 4, expansion, true);
        this.arm0.setRotationPoint(-5.0f, 2.0f + yRotOffset, 0.0f);
        this.leg0 = new Cube(0, 16, 64, 64);
        this.leg0.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, expansion, true);
        this.leg0.setRotationPoint(-2.0f, 12.0f + yRotOffset, 0.0f);
    }

    @Override
    public void render(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        super.render(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        GL11.glPushMatrix();
        this.bipedLeftArmOverlay.render(scale);
        this.bipedRightArmOverlay.render(scale);
        this.bipedLeftLegOverlay.render(scale);
        this.bipedRightLegOverlay.render(scale);
        this.bipedBodyOverlay.render(scale);
        GL11.glPopMatrix();
    }

    @Override
    public void setupAnimation(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        super.setupAnimation(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        PlayerModel.copyTranslation(this.leg1, this.bipedLeftLegOverlay);
        PlayerModel.copyTranslation(this.leg0, this.bipedRightLegOverlay);
        PlayerModel.copyTranslation(this.arm1, this.bipedLeftArmOverlay);
        PlayerModel.copyTranslation(this.arm0, this.bipedRightArmOverlay);
        PlayerModel.copyTranslation(this.body, this.bipedBodyOverlay);
    }

    public static void copyTranslation(Cube sourceCube, Cube destinationCube) {
        destinationCube.xRot = sourceCube.xRot;
        destinationCube.yRot = sourceCube.yRot;
        destinationCube.zRot = sourceCube.zRot;
        destinationCube.x = sourceCube.x;
        destinationCube.y = sourceCube.y;
        destinationCube.z = sourceCube.z;
    }
}

