/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tessellator;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.minecraft.client.render.terrain.VertexConfig;
import net.minecraft.client.render.terrain.VertexData;
import net.minecraft.client.render.tessellator.TessellatorBase;
import net.minecraft.core.util.helper.MathHelper;

public class TessellatorStandard
extends TessellatorBase {
    public VertexData data;
    public boolean drawing;
    private int color;
    private int lightmapCoord;
    private double textureU;
    private double textureV;
    private byte normalX;
    private byte normalY;
    private byte normalZ;
    private double offsetX;
    private double offsetY;
    private double offsetZ;
    private boolean lockedColor = false;

    public TessellatorStandard(int bufferSize) {
        this.data = new VertexData(bufferSize);
    }

    @Override
    public void startDrawing(int drawMode) {
        if (this.drawing) {
            throw new IllegalStateException("Already drawing!");
        }
        VertexConfig config = this.data.config;
        config.drawMode = drawMode;
        this.drawing = true;
        this.data.vertexCount = 0;
        config.enableColor = false;
        config.enableTexture = false;
        config.enableLightmap = false;
        config.enableNormal = false;
        this.lockedColor = false;
        this.data.buffer.clear();
    }

    @Override
    public void draw() {
        this.checkIsDrawing();
        this.drawing = false;
        if (this.data.vertexCount == 0) {
            return;
        }
        this.data.buffer.flip();
        this.data.drawAll();
    }

    public int getVertexSize() {
        return this.data.config.getVertexSize();
    }

    @Override
    public void addVertex(double x, double y, double z) {
        this.checkIsDrawing();
        if (this.data.buffer.capacity() < this.data.buffer.position() + 64) {
            int newSize = this.data.buffer.capacity() * 2;
            System.out.println("Expanding Tessellator Buffer (" + this.data.buffer.capacity() + " -> " + newSize + ")");
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(newSize).order(ByteOrder.nativeOrder());
            this.data.buffer.flip();
            newBuffer.put(this.data.buffer);
            this.data.buffer = newBuffer;
        }
        ByteBuffer buffer = this.data.buffer;
        buffer.putFloat((float)(this.offsetX + x));
        buffer.putFloat((float)(this.offsetY + y));
        buffer.putFloat((float)(this.offsetZ + z));
        VertexConfig config = this.data.config;
        if (config.enableColor) {
            buffer.putInt(this.color);
        }
        if (config.enableTexture) {
            buffer.putFloat((float)this.textureU);
            buffer.putFloat((float)this.textureV);
        }
        if (config.enableLightmap) {
            buffer.putInt(this.lightmapCoord);
        }
        if (config.enableNormal) {
            buffer.put(this.normalX);
            buffer.put(this.normalY);
            buffer.put(this.normalZ);
        }
        ++this.data.vertexCount;
    }

    @Override
    public void setTextureUV(double u, double v) {
        this.checkIsDrawing();
        if (!this.data.config.enableTexture) {
            if (this.data.vertexCount > 0) {
                throw new IllegalStateException("Texture is disabled!");
            }
            this.data.config.enableTexture = true;
        }
        this.textureU = u;
        this.textureV = v;
    }

    @Override
    public void setLightmapCoord(int lightmapCoord) {
        this.checkIsDrawing();
        if (!this.data.config.enableLightmap) {
            if (this.data.vertexCount > 0) {
                throw new IllegalStateException("Lightmap is disabled!");
            }
            this.data.config.enableLightmap = true;
        }
        this.lightmapCoord = lightmapCoord;
    }

    @Override
    public void setColorRGBA(int r, int g, int b, int a) {
        this.checkIsDrawing();
        if (this.lockedColor) {
            return;
        }
        if (!this.data.config.enableColor) {
            if (this.data.vertexCount > 0) {
                throw new IllegalStateException("Color is disabled!");
            }
            this.data.config.enableColor = true;
        }
        r = MathHelper.clamp(r, 0, 255);
        g = MathHelper.clamp(g, 0, 255);
        b = MathHelper.clamp(b, 0, 255);
        a = MathHelper.clamp(a, 0, 255);
        this.color = a << 24 | b << 16 | g << 8 | r;
    }

    @Override
    public void setNormal(float x, float y, float z) {
        this.checkIsDrawing();
        if (!this.data.config.enableNormal) {
            if (this.data.vertexCount > 0) {
                throw new IllegalStateException("Texture is disabled!");
            }
            this.data.config.enableNormal = true;
        }
        this.normalX = (byte)(x * 127.0f);
        this.normalY = (byte)(y * 127.0f);
        this.normalZ = (byte)(z * 127.0f);
    }

    @Override
    public void lockColor() {
        this.checkIsDrawing();
        this.lockedColor = true;
    }

    @Override
    public void setTranslation(double x, double y, double z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
    }

    @Override
    public void offsetTranslation(float x, float y, float z) {
        this.offsetX += (double)x;
        this.offsetY += (double)y;
        this.offsetZ += (double)z;
    }

    @Override
    public void checkIsDrawing() {
        if (!this.drawing) {
            throw new IllegalStateException("Not drawing!");
        }
    }
}

