/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texture;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.enums.MipmapType;
import net.minecraft.client.render.texture.meta.TextureProperties;
import net.minecraft.core.util.helper.Buffer;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class Texture {
    public static boolean debugMipmap = false;
    protected static final boolean fixArtifacts = true;
    protected int id;

    public void init() {
    }

    public boolean hasMeta(String key) {
        return false;
    }

    @Nullable
    public <T> T getMeta(String key, Class<T> aClass) {
        return null;
    }

    public <T> T getOrDefaultMeta(String key, T metaDefault, Class<T> aClass) {
        return metaDefault;
    }

    public boolean generate() {
        if (this.isGenerated()) {
            return false;
        }
        this.id = GLAllocation.generateTexture();
        if (!this.isGenerated()) {
            throw new RuntimeException("Texture not created!");
        }
        return true;
    }

    public boolean delete() {
        if (!this.isGenerated()) {
            return false;
        }
        GLAllocation.deleteTexture(this.id);
        this.id = 0;
        return true;
    }

    public boolean bind() {
        if (!this.isGenerated()) {
            return false;
        }
        GL11.glBindTexture((int)3553, (int)this.id);
        return true;
    }

    public void unbind() {
        GL11.glBindTexture((int)3553, (int)0);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.delete();
    }

    public boolean isGenerated() {
        return this.id != 0;
    }

    public int getWidth() {
        return GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
    }

    public int getHeight() {
        return GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
    }

    public int id() {
        return this.id;
    }

    public void setupTexture(BufferedImage image) {
        boolean blurTexture = false;
        boolean clampTexture = false;
        boolean mipmap = false;
        if (this.hasMeta("texture")) {
            TextureProperties properties = this.getMeta("texture", TextureProperties.class);
            blurTexture = properties.blur;
            clampTexture = properties.clamp;
            mipmap = properties.mipmap;
        }
        this.setupTexture(image, blurTexture, clampTexture, mipmap);
    }

    public void setupTexture(BufferedImage img, boolean blurTexture, boolean clampTexture, boolean mipmap) {
        this.bind();
        if (blurTexture) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        if (clampTexture) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        } else {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
        int w = img.getWidth();
        int h = img.getHeight();
        Buffer.put(img);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)w, (int)h, (int)0, (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
        if (mipmap) {
            Minecraft mc = Minecraft.getMinecraft(this);
            this.generateMipmaps(Buffer.buffer, img, (Integer)mc.gameSettings.mipmapLevels.value, mc.gameSettings.mipmapType.value == MipmapType.SMOOTH);
        }
    }

    protected void generateMipmaps(ByteBuffer buffer, BufferedImage image, int levels, boolean smooth) {
        System.out.println("Generating Mipmaps...");
        int width = image.getWidth();
        int height = image.getHeight();
        int[] data = new int[width * height];
        int[] newData = null;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                data[width * y + x] = image.getRGB(x, y);
            }
        }
        for (int level = levels; level > 0; --level) {
            int lod = (int)Math.pow(2.0, level);
            int tilesX = width / lod;
            int tilesY = height / lod;
            for (int x = 0; x < tilesX; ++x) {
                for (int y = 0; y < tilesY; ++y) {
                    int color;
                    int x0;
                    int y0;
                    int j;
                    int i;
                    Integer nonTransparentColor = null;
                    block5: for (i = 0; i < lod; ++i) {
                        for (j = 0; j < lod; ++j) {
                            y0 = y * lod + j;
                            x0 = x * lod + i;
                            color = data[width * y0 + x0];
                            if ((color >> 24 & 0xFF) <= 0) continue;
                            nonTransparentColor = color;
                            break block5;
                        }
                    }
                    if (nonTransparentColor == null) continue;
                    nonTransparentColor = nonTransparentColor & 0xFFFFFF;
                    for (i = 0; i < lod; ++i) {
                        for (j = 0; j < lod; ++j) {
                            y0 = y * lod + j;
                            x0 = x * lod + i;
                            color = data[width * y0 + x0];
                            if ((color >> 24 & 0xFF) != 0) continue;
                            data[width * y0 + x0] = nonTransparentColor;
                        }
                    }
                }
            }
        }
        int previousWidth = width;
        int newWidth = width;
        int newHeight = height;
        for (int level = 0; level <= levels; ++level) {
            newData = new int[newWidth * newHeight];
            for (int y = 0; y < newHeight; ++y) {
                for (int x = 0; x < newWidth; ++x) {
                    int color;
                    if (level == 0) {
                        color = data[width * y + x];
                    } else {
                        int x1 = x << 1;
                        int y1 = y << 1;
                        if (smooth) {
                            int color0 = data[previousWidth * (y1 + 0) + (x1 + 0)];
                            int color1 = data[previousWidth * (y1 + 0) + (x1 + 1)];
                            int color2 = data[previousWidth * (y1 + 1) + (x1 + 0)];
                            int color3 = data[previousWidth * (y1 + 1) + (x1 + 1)];
                            color = this.blendColor(this.blendColor(color0, color1), this.blendColor(color2, color3));
                        } else {
                            color = data[previousWidth * y1 + x1];
                        }
                    }
                    newData[y * newWidth + x] = color;
                }
            }
            buffer.position(0).limit(buffer.capacity());
            for (int i = 0; i < newData.length; ++i) {
                int color = newData[i];
                buffer.put((byte)(color >> 16 & 0xFF));
                buffer.put((byte)(color >> 8 & 0xFF));
                buffer.put((byte)(color >> 0 & 0xFF));
                buffer.put((byte)(color >> 24 & 0xFF));
            }
            buffer.limit(buffer.position()).flip();
            GL11.glTexImage2D((int)3553, (int)(debugMipmap ? 0 : level), (int)6408, (int)newWidth, (int)newHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
            if (!debugMipmap) {
                GL11.glTexParameteri((int)3553, (int)33085, (int)level);
                GL11.glTexParameteri((int)3553, (int)10241, (int)9986);
            }
            data = newData;
            previousWidth = newWidth;
            newWidth /= 2;
            newHeight /= 2;
        }
    }

    protected int blendColor(int color0, int color1) {
        int alpha0 = color0 >> 24 & 0xFF;
        int alpha1 = color1 >> 24 & 0xFF;
        int alphaAvg = (alpha0 + alpha1) / 2;
        if (alpha0 == 0 && alpha1 == 0) {
            alpha0 = 1;
            alpha1 = 1;
        } else {
            if (alpha0 == 0) {
                color0 = color1;
                alphaAvg /= 2;
            }
            if (alpha1 == 0) {
                color1 = color0;
                alphaAvg /= 2;
            }
        }
        int r0 = (color0 >> 16 & 0xFF) * alpha0;
        int g0 = (color0 >> 8 & 0xFF) * alpha0;
        int b0 = (color0 >> 0 & 0xFF) * alpha0;
        int r1 = (color1 >> 16 & 0xFF) * alpha1;
        int g1 = (color1 >> 8 & 0xFF) * alpha1;
        int b1 = (color1 >> 0 & 0xFF) * alpha1;
        int rAvg = (r0 + r1) / (alpha0 + alpha1);
        int gAvg = (g0 + g1) / (alpha0 + alpha1);
        int bAvg = (b0 + b1) / (alpha0 + alpha1);
        return alphaAvg << 24 | rAvg << 16 | gAvg << 8 | bAvg;
    }
}

