/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.window;

import com.github.zarzelcow.legacylwjgl3.implementation.glfw.GLFWKeyboardImplementation;
import com.github.zarzelcow.legacylwjgl3.implementation.glfw.GLFWMouseImplementation;
import com.github.zarzelcow.legacylwjgl3.implementation.input.CombinedInputImplementation;
import com.github.zarzelcow.legacylwjgl3.implementation.input.InputImplementation;
import com.github.zarzelcow.legacylwjgl3.implementation.input.KeyboardImplementation;
import com.github.zarzelcow.legacylwjgl3.implementation.input.MouseImplementation;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JFrame;
import net.minecraft.client.GameResolution;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.PanelCrashReport;
import net.minecraft.client.render.window.GameWindow;
import net.minecraft.core.UnexpectedThrowable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL;

public class GameWindowGLFW
implements GameWindow {
    public Minecraft mc;
    public long window;
    public int width = GameResolution.defaultWidth;
    public int height = GameResolution.defaultHeight;
    private boolean wasResized = false;
    private boolean isFullscreen = false;
    private int windowPosX;
    private int windowPosY;
    private int windowWidth;
    private int windowHeight;

    @Override
    public void init(Minecraft minecraft) {
        this.mc = minecraft;
        System.out.println("GLFW Init");
        if (!GLFW.glfwInit()) {
            throw new RuntimeException("GLFW Init failed!");
        }
        GLFW.glfwWindowHint((int)131075, (int)1);
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131078, (int)1);
        GLFW.glfwWindowHint((int)131077, (int)1);
        this.window = GLFW.glfwCreateWindow((int)this.width, (int)this.height, (CharSequence)"Minecraft", (long)0L, (long)0L);
        MonitorInfo monitor = new MonitorInfo(GLFW.glfwGetPrimaryMonitor());
        GLFW.glfwSetWindowPos((long)this.window, (int)((monitor.width - this.width) / 2), (int)((monitor.height - this.height) / 2));
        GLFW.glfwSetWindowSizeCallback((long)this.window, (window, width, height) -> {
            this.width = Math.max(1, width);
            this.height = Math.max(1, height);
            this.wasResized = true;
        });
        GLFW.glfwShowWindow((long)this.window);
        GLFW.glfwMakeContextCurrent((long)this.window);
        GL.createCapabilities();
        Display.setWindow(this);
        Method createKeyboard = null;
        Method createMouse = null;
        try {
            createKeyboard = Keyboard.class.getDeclaredMethod("create", InputImplementation.class);
            createKeyboard.setAccessible(true);
            createMouse = Mouse.class.getDeclaredMethod("create", InputImplementation.class);
            createMouse.setAccessible(true);
            GLFWKeyboardImplementation keyboardImplementation = new GLFWKeyboardImplementation();
            GLFWMouseImplementation mouseImplementation = new GLFWMouseImplementation();
            CombinedInputImplementation inputImplementation = new CombinedInputImplementation((KeyboardImplementation)keyboardImplementation, (MouseImplementation)mouseImplementation);
            createKeyboard.invoke(null, inputImplementation);
            createMouse.invoke(null, inputImplementation);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.setVsync((Boolean)this.mc.gameSettings.enableVsync.value);
    }

    @Override
    public void toggleFullscreen() {
        this.mc.gameSettings.fullscreen.value = (Boolean)this.mc.gameSettings.fullscreen.value == false;
        this.updateWindowState();
    }

    @Override
    public void updateWindowState() {
        if (!this.isFullscreen) {
            int[] x = new int[1];
            int[] y = new int[1];
            GLFW.glfwGetWindowPos((long)this.window, (int[])x, (int[])y);
            int[] w = new int[1];
            int[] h = new int[1];
            GLFW.glfwGetWindowSize((long)this.window, (int[])w, (int[])h);
            this.windowPosX = x[0];
            this.windowPosY = y[0];
            this.windowWidth = w[0];
            this.windowHeight = h[0];
        }
        boolean fullscreen = (Boolean)this.mc.gameSettings.fullscreen.value;
        boolean borderless = (Boolean)this.mc.gameSettings.borderlessFullscreen.value;
        GLFW.glfwHideWindow((long)this.window);
        if (fullscreen && !borderless) {
            System.out.println("Change to Fullscreen");
            int x = this.windowPosX + this.windowWidth / 2;
            int y = this.windowPosY + this.windowHeight / 2;
            MonitorInfo monitor = this.getMonitorAt(x, y);
            GLFW.glfwSetWindowMonitor((long)this.window, (long)monitor.handle, (int)monitor.posX, (int)monitor.posY, (int)monitor.width, (int)monitor.height, (int)monitor.refreshRate);
            this.isFullscreen = true;
        } else {
            GLFW.glfwSetWindowMonitor((long)this.window, (long)0L, (int)this.windowPosX, (int)this.windowPosY, (int)this.windowWidth, (int)this.windowHeight, (int)0);
            if (fullscreen && borderless) {
                System.out.println("Change to Borderless Fullscreen");
                int x = this.windowPosX + this.windowWidth / 2;
                int y = this.windowPosY + this.windowHeight / 2;
                MonitorInfo monitor = this.getMonitorAt(x, y);
                GLFW.glfwSetWindowAttrib((long)this.window, (int)131077, (int)0);
                GLFW.glfwSetWindowPos((long)this.window, (int)monitor.posX, (int)monitor.posY);
                GLFW.glfwSetWindowSize((long)this.window, (int)monitor.width, (int)monitor.height);
                this.isFullscreen = true;
            } else {
                System.out.println("Change to Windowed");
                GLFW.glfwSetWindowAttrib((long)this.window, (int)131077, (int)1);
                this.isFullscreen = false;
            }
        }
        GLFW.glfwShowWindow((long)this.window);
    }

    public MonitorInfo getMonitorAt(int x, int y) {
        PointerBuffer monitorPointers = GLFW.glfwGetMonitors();
        for (int i = monitorPointers.position(); i < monitorPointers.limit(); ++i) {
            long monitor = monitorPointers.get(i);
            MonitorInfo info = new MonitorInfo(monitor);
            if (x < info.posX || y < info.posY || x >= info.posX + info.width || y >= info.posY + info.height) continue;
            return info;
        }
        return new MonitorInfo(GLFW.glfwGetPrimaryMonitor());
    }

    @Override
    public void displayCrashReport(UnexpectedThrowable unexpectedThrowable, int cause) {
        JFrame frame = new JFrame();
        PanelCrashReport panel = new PanelCrashReport(this.mc, unexpectedThrowable, cause);
        panel.setPreferredSize(new Dimension(1280, 720));
        frame.add(panel);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }

    @Override
    public int getFrequency() {
        GLFWVidMode vidMode = GLFW.glfwGetVideoMode((long)this.window);
        if (vidMode != null) {
            return vidMode.refreshRate();
        }
        int x = this.windowPosX + this.windowWidth / 2;
        int y = this.windowPosY + this.windowHeight / 2;
        MonitorInfo monitor = this.getMonitorAt(x, y);
        return monitor.refreshRate;
    }

    @Override
    public void update() {
        GLFW.glfwPollEvents();
        Keyboard.poll();
        Mouse.poll();
        GLFW.glfwSwapBuffers((long)this.window);
    }

    @Override
    public boolean shouldClose() {
        return GLFW.glfwWindowShouldClose((long)this.window);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isFocused() {
        return true;
    }

    @Override
    public boolean wasResized() {
        if (this.wasResized) {
            this.wasResized = false;
            return true;
        }
        return false;
    }

    @Override
    public void setVsync(boolean vsync) {
        if (vsync) {
            GLFW.glfwSwapInterval((int)1);
        } else {
            GLFW.glfwSwapInterval((int)0);
        }
    }

    public static class MonitorInfo {
        public final long handle;
        public final int posX;
        public final int posY;
        public final int width;
        public final int height;
        public final int refreshRate;

        public MonitorInfo(long monitor) {
            this.handle = monitor;
            GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)monitor);
            int[] x = new int[1];
            int[] y = new int[1];
            GLFW.glfwGetMonitorPos((long)monitor, (int[])x, (int[])y);
            this.posX = x[0];
            this.posY = y[0];
            this.width = vidmode.width();
            this.height = vidmode.height();
            this.refreshRate = vidmode.refreshRate();
        }
    }
}

