/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sound;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import net.betterthanadventure.sound.LibraryLWJGL3OpenAL;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.sound.CodecMus;
import net.minecraft.client.sound.SoundCategoryHelper;
import net.minecraft.client.sound.SoundEntry;
import net.minecraft.client.sound.SoundRepository;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.MathHelper;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.codecs.CodecJOrbis;
import paulscode.sound.codecs.CodecWav;

public class SoundEngine {
    private static final int SOUND_DISTANCE = 16;
    public static final int MUSIC_INTERVAL = 6000;
    private static SoundSystem soundSystem;
    private static boolean loaded;
    public final SoundRepository soundRepo = new SoundRepository();
    public final SoundRepository streamingRepo = new SoundRepository();
    public final SoundRepository musicRepo = new SoundRepository();
    public final SoundRepository caveRepo = new SoundRepository();
    private int idCounter = 0;
    private GameSettings options;
    private final Random random = new Random();
    private Minecraft mc;
    public int ticksBeforeMusic = this.random.nextInt(6000);
    private boolean muted = false;

    private static void loadModAudio(String directory, SoundRepository targetRepo) {
        File file = Minecraft.getAppDir(directory);
        try {
            SoundEngine.walkFolder(file, file, targetRepo);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    private static void loadDevAudio(String directory, SoundRepository targetRepo) {
        File file = new File(directory);
        try {
            SoundEngine.walkFolder(file, file, targetRepo);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    private static void walkFolder(File baseFile, File currentFile, SoundRepository targetRepo) throws IOException {
        File[] filesInCurrentDir;
        if ((currentFile.exists() || currentFile.mkdirs()) && (filesInCurrentDir = currentFile.listFiles()) != null) {
            for (File file : filesInCurrentDir) {
                if (file.getName().startsWith(".")) continue;
                if (file.isDirectory()) {
                    SoundEngine.walkFolder(baseFile, file, targetRepo);
                    continue;
                }
                if (!file.isFile()) continue;
                String name = file.getPath().substring(baseFile.getPath().length() + 1).replace('\\', '/');
                targetRepo.addSound(name, file);
            }
        }
    }

    public void addMusic(String name, File file) {
        this.musicRepo.addSound(name, file);
    }

    public void addSound(String name, File file) {
        this.soundRepo.addSound(name, file);
    }

    public void addStreaming(String name, File file) {
        this.streamingRepo.addSound(name, file);
    }

    public void destroy() {
        if (loaded) {
            soundSystem.cleanup();
        }
    }

    public void setMuted(boolean muted) {
        if (soundSystem == null) {
            return;
        }
        this.muted = muted;
        if (this.muted) {
            soundSystem.setVolume("BgMusic", 0.0f);
        } else {
            soundSystem.setVolume("BgMusic", SoundCategoryHelper.getEffectiveVolume(SoundCategory.MUSIC, this.options));
        }
    }

    public void updateListener(Mob player, float partialTick) {
        if (!loaded || this.muted || soundSystem == null || !SoundCategoryHelper.isAnyEnabled(this.options)) {
            return;
        }
        if (player != null) {
            float yRot = MathHelper.lerp(player.yRotO, player.yRot, partialTick);
            double playerX = MathHelper.lerp(player.xo, player.x, (double)partialTick);
            double playerY = MathHelper.lerp(player.yo, player.y, (double)partialTick);
            double playerZ = MathHelper.lerp(player.zo, player.z, (double)partialTick);
            float yCos = MathHelper.cos(MathHelper.toRadians(-yRot - 180.0f));
            float ySin = MathHelper.sin(MathHelper.toRadians(-yRot - 180.0f));
            float xa = -ySin;
            float ya = 0.0f;
            float za = -yCos;
            float xa2 = 0.0f;
            float ya2 = 1.0f;
            float za2 = 0.0f;
            soundSystem.setListenerPosition((float)playerX, (float)playerY, (float)playerZ);
            soundSystem.setListenerOrientation(xa, 0.0f, za, 0.0f, 1.0f, 0.0f);
        }
    }

    public void init(GameSettings gamesettings) {
        this.streamingRepo.trimDigits = false;
        this.options = gamesettings;
        if (!loaded && gamesettings != null && SoundCategoryHelper.isAnyEnabled(gamesettings)) {
            this.loadLibrary();
        }
        if (gamesettings != null && ((Boolean)gamesettings.enableDevResourceLoading.value).booleanValue()) {
            SoundEngine.loadDevAudio("devResources/sound", this.soundRepo);
            SoundEngine.loadDevAudio("devResources/streaming", this.streamingRepo);
            SoundEngine.loadDevAudio("devResources/music", this.musicRepo);
            SoundEngine.loadDevAudio("devResources/cavemusic", this.caveRepo);
        }
        SoundEngine.loadModAudio("minecraft-bta/resources/mod/sound", this.soundRepo);
        SoundEngine.loadModAudio("minecraft-bta/resources/mod/streaming", this.streamingRepo);
        SoundEngine.loadModAudio("minecraft-bta/resources/mod/music", this.musicRepo);
        SoundEngine.loadModAudio("minecraft-bta/resources/mod/cavemusic", this.caveRepo);
        this.mc = Minecraft.getMinecraft(this);
    }

    public void updateOptions() {
        if (!loaded && SoundCategoryHelper.isAnyEnabled(this.options)) {
            this.loadLibrary();
        }
        if (soundSystem != null && loaded) {
            if (SoundCategoryHelper.getEffectiveVolume(SoundCategory.MUSIC, this.options) == 0.0f) {
                soundSystem.stop("BgMusic");
            } else {
                soundSystem.setVolume("BgMusic", SoundCategoryHelper.getEffectiveVolume(SoundCategory.MUSIC, this.options));
            }
        }
    }

    public void tick() {
        if (!loaded || soundSystem == null || SoundCategoryHelper.getEffectiveVolume(SoundCategory.MUSIC, this.options) == 0.0f) {
            return;
        }
        if (!soundSystem.playing("BgMusic") && !soundSystem.playing("streaming")) {
            if (this.ticksBeforeMusic > 0) {
                --this.ticksBeforeMusic;
                return;
            }
            SoundEntry entry = this.mc != null && this.mc.thePlayer != null && !this.mc.thePlayer.world.canBlockSeeTheSky(MathHelper.floor(this.mc.thePlayer.x), MathHelper.floor(this.mc.thePlayer.y), MathHelper.floor(this.mc.thePlayer.z)) ? this.caveRepo.getAnyEntry() : this.musicRepo.getAnyEntry();
            if (entry != null) {
                this.ticksBeforeMusic = this.random.nextInt(6000) + 6000;
                soundSystem.backgroundMusic("BgMusic", entry.url, entry.name, false);
                soundSystem.setVolume("BgMusic", SoundCategoryHelper.getEffectiveVolume(SoundCategory.MUSIC, this.options));
                soundSystem.play("BgMusic");
            }
        }
    }

    public void playSoundAt(String soundPath, SoundCategory category, float x, float y, float z, float volume, float pitch) {
        if (!loaded || soundSystem == null || this.muted || !SoundCategoryHelper.isAnyEnabled(this.options)) {
            return;
        }
        SoundEntry soundEntry = this.soundRepo.getEntry(soundPath);
        if (soundEntry != null && volume > 0.0f) {
            this.idCounter = (this.idCounter + 1) % 256;
            String soundIdName = "sound_" + this.idCounter;
            float f5 = 16.0f;
            if (volume > 1.0f) {
                f5 *= volume;
            }
            soundSystem.newSource(volume > 1.0f, soundIdName, soundEntry.url, soundEntry.name, false, x, y, z, 2, f5);
            soundSystem.setPitch(soundIdName, pitch);
            if (volume > 1.0f) {
                volume = 1.0f;
            }
            soundSystem.setVolume(soundIdName, volume * SoundCategoryHelper.getEffectiveVolume(category, this.options));
            soundSystem.play(soundIdName);
        }
    }

    public void playSound(String soundPath, SoundCategory category, float volume, float pitch) {
        if (!loaded || soundSystem == null || this.muted || !SoundCategoryHelper.isAnyEnabled(this.options)) {
            return;
        }
        SoundEntry soundEntry = this.soundRepo.getEntry(soundPath);
        this.idCounter = (this.idCounter + 1) % 256;
        String soundName = "sound_" + this.idCounter;
        this.playSoundEntry(soundEntry, soundName, category, volume, pitch);
    }

    public void playSoundEntry(SoundEntry entry, String soundSourceID, SoundCategory category, float volume, float pitch) {
        if (entry != null) {
            soundSystem.newSource(false, soundSourceID, entry.url, entry.name, false, 0.0f, 0.0f, 0.0f, 0, 0.0f);
            if (volume > 1.0f) {
                volume = 1.0f;
            }
            soundSystem.setPitch(soundSourceID, pitch);
            soundSystem.setVolume(soundSourceID, (volume *= 0.25f) * SoundCategoryHelper.getEffectiveVolume(category, this.options));
            soundSystem.play(soundSourceID);
        }
    }

    public void playSoundId(String soundPath, SoundCategory category, float volume, float pitch, String soundID) {
        if (!loaded || soundSystem == null || this.muted || !SoundCategoryHelper.isAnyEnabled(this.options)) {
            return;
        }
        SoundEntry soundEntry = this.soundRepo.getEntry(soundPath);
        this.playSoundEntry(soundEntry, soundID, category, volume, pitch);
    }

    public void playStreaming(String soundPath, float x, float y, float z, float volume, float pitch) {
        if (!loaded || soundSystem == null || this.muted || !SoundCategoryHelper.isAnyEnabled(this.options)) {
            return;
        }
        String streaming = "streaming";
        if (soundSystem.playing("streaming")) {
            soundSystem.stop("streaming");
        }
        if (soundPath == null) {
            return;
        }
        SoundEntry soundEntry = this.streamingRepo.getEntry(soundPath);
        if (soundEntry != null && volume > 0.0f) {
            if (soundSystem.playing("BgMusic")) {
                soundSystem.stop("BgMusic");
            }
            float streamingVolume = 16.0f;
            soundSystem.newStreamingSource(true, "streaming", soundEntry.url, soundEntry.name, false, x, y, z, 2, 64.0f);
            soundSystem.setVolume("streaming", 0.5f * ((Float)this.options.masterVolume.value).floatValue());
            soundSystem.play("streaming");
        }
    }

    private void loadLibrary() {
        try {
            int i;
            float[] volumeStore = new float[SoundCategory.values().length];
            for (i = 0; i < SoundCategory.values().length; ++i) {
                volumeStore[i] = SoundCategoryHelper.getVolume(SoundCategory.values()[i], this.options);
            }
            this.options.saveOptions();
            SoundSystemConfig.addLibrary(LibraryLWJGL3OpenAL.class);
            SoundSystemConfig.setCodec((String)"ogg", CodecJOrbis.class);
            SoundSystemConfig.setCodec((String)"mus", CodecMus.class);
            SoundSystemConfig.setCodec((String)"wav", CodecWav.class);
            soundSystem = new SoundSystem();
            for (i = 0; i < SoundCategory.values().length; ++i) {
                SoundCategoryHelper.setVolume(SoundCategory.values()[i], this.options, volumeStore[i]);
            }
            this.options.saveOptions();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.err.println("error linking with the LibraryJavaSound plug-in");
        }
        loaded = true;
    }

    public static SoundSystem getSoundSystem() {
        return soundSystem;
    }

    static {
        loaded = false;
    }
}

