/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.item.ItemStack;

public class WeightedRandomBag<T> {
    private final List<Entry> entries = new ArrayList<Entry>();
    private double accumulatedWeight;
    private final Random rand = new Random();

    public void addEntry(T object, double weight) {
        this.accumulatedWeight += weight;
        Entry e = new Entry();
        e.object = object;
        e.weight = weight;
        e.accumulatedWeight = this.accumulatedWeight;
        this.entries.add(e);
    }

    public T getRandom() {
        return this.getRandom(this.rand);
    }

    public T getRandom(Random random) {
        double r = random.nextDouble() * this.accumulatedWeight;
        for (Entry entry : this.entries) {
            if (!(entry.accumulatedWeight >= r)) continue;
            return (T)entry.object;
        }
        return null;
    }

    public List<T> getEntries() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Entry entry : this.entries) {
            list.add(entry.object);
        }
        return Collections.unmodifiableList(list);
    }

    public List<Entry> getEntriesWithWeights() {
        return Collections.unmodifiableList(this.entries);
    }

    public double getAsPercentage(ItemStack stack) {
        double weight = 0.0;
        for (Entry entry : this.entries) {
            if (!(entry.object instanceof WeightedRandomLootObject) || !((WeightedRandomLootObject)entry.object).getItemStack().isItemEqual(stack)) continue;
            weight = entry.weight;
        }
        return weight / this.accumulatedWeight * 100.0;
    }

    public void clear() {
        this.entries.clear();
        this.accumulatedWeight = 0.0;
    }

    public class Entry {
        private double accumulatedWeight;
        private T object;
        private double weight;

        public double getWeight() {
            return this.weight;
        }

        public T getObject() {
            return this.object;
        }
    }
}

