/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.Global;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.FurnaceBlock;
import net.minecraft.core.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class BlastFurnaceBlock
extends FurnaceBlock {
    public BlastFurnaceBlock(String key, String namespaceId, int id, boolean flag) {
        super(key, namespaceId, id, flag);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        switch (dropCause) {
            case PICK_BLOCK: 
            case EXPLOSION: 
            case PROPER_TOOL: 
            case SILK_TOUCH: {
                return new ItemStack[]{new ItemStack(Blocks.FURNACE_BLAST_IDLE)};
            }
        }
        return null;
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (!world.isClientSide) {
            BlastFurnaceBlockEntity tileentityblastfurnace = (BlastFurnaceBlockEntity)world.getBlockEntity(x, y, z);
            player.displayGUIFurnace(tileentityblastfurnace);
        }
        return true;
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        if (!this.isActive) {
            return;
        }
        int l = world.getBlockMetadata(x, y, z);
        double posX = (double)x + 0.5;
        double posY = (double)y + (double)(rand.nextFloat() * 6.0f) / 16.0;
        double posZ = (double)z + 0.5;
        double f3 = 0.52;
        float f4 = rand.nextFloat() * 0.6f - 0.3f;
        if (l == 4) {
            world.spawnParticle("smoke", posX - f3, posY, posZ + (double)f4, 0.0, 0.0, 0.0, 0);
            world.spawnParticle("largeSmoke", posX - f3, posY, posZ + (double)f4, 0.0, 0.0, 0.0, 0);
        } else if (l == 5) {
            world.spawnParticle("smoke", posX + f3, posY, posZ + (double)f4, 0.0, 0.0, 0.0, 0);
            world.spawnParticle("largeSmoke", posX + f3, posY, posZ + (double)f4, 0.0, 0.0, 0.0, 0);
        } else if (l == 2) {
            world.spawnParticle("smoke", posX + (double)f4, posY, posZ - f3, 0.0, 0.0, 0.0, 0);
            world.spawnParticle("largeSmoke", posX + (double)f4, posY, posZ - f3, 0.0, 0.0, 0.0, 0);
        } else if (l == 3) {
            world.spawnParticle("smoke", posX + (double)f4, posY, posZ + f3, 0.0, 0.0, 0.0, 0);
            world.spawnParticle("largeSmoke", posX + (double)f4, posY, posZ + f3, 0.0, 0.0, 0.0, 0);
        }
    }

    public static void updateFurnaceBlockState(boolean lit, World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        BlockEntity tileentity = world.getBlockEntity(x, y, z);
        if (tileentity == null) {
            String msg = "Blast Furnace is missing Tile Entity at x: " + x + " y: " + y + " z: " + z + ", block will be removed!";
            if (Global.BUILD_CHANNEL.isUnstableBuild()) {
                throw new RuntimeException(msg);
            }
            world.setBlockWithNotify(x, y, z, 0);
            System.out.println(msg);
            return;
        }
        keepFurnaceInventory = true;
        if (lit) {
            world.setBlockWithNotify(x, y, z, Blocks.FURNACE_BLAST_ACTIVE.id);
        } else {
            world.setBlockWithNotify(x, y, z, Blocks.FURNACE_BLAST_IDLE.id);
        }
        keepFurnaceInventory = false;
        world.setBlockMetadataWithNotify(x, y, z, meta);
        tileentity.validate();
        world.setBlockTileEntity(x, y, z, tileentity);
    }

    @Override
    protected BlockEntity getNewBlockEntity() {
        return new BlastFurnaceBlockEntity();
    }
}

