/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.CherryLeavesBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.season.Seasons;

public class FloweringCherryLeavesBlock
extends CherryLeavesBlock
implements IBonemealable {
    public static final int MASK_GROWTH_DATA = 240;

    public FloweringCherryLeavesBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        int growthRate = FloweringCherryLeavesBlock.getGrowthRate(meta);
        if (dropCause == EnumDropCause.PICK_BLOCK || dropCause == EnumDropCause.SILK_TOUCH) {
            return new ItemStack[]{new ItemStack(this)};
        }
        if (growthRate == 0) {
            return null;
        }
        return new ItemStack[]{new ItemStack(Items.FOOD_CHERRY, world.rand.nextInt(2) + 1)};
    }

    @Override
    public void onBlockLeftClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        this.onBlockRightClicked(world, x, y, z, player, null, 0.0, 0.0);
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        int meta = world.getBlockMetadata(x, y, z);
        int decayData = meta & 0xF;
        int growthRate = FloweringCherryLeavesBlock.getGrowthRate(meta);
        if (growthRate > 0) {
            world.playSoundAtEntity(player, player, "random.pop", 0.2f, 0.5f);
            if (!world.isClientSide) {
                this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, meta, null);
            }
            world.setBlockMetadataWithNotify(x, y, z, decayData);
            world.scheduleBlockUpdate(x, y, z, Blocks.LEAVES_CHERRY_FLOWERING.id, this.tickDelay());
            return true;
        }
        return super.onBlockRightClicked(world, x, y, z, player, side, xPlaced, yPlaced);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        super.updateTick(world, x, y, z, rand);
        int meta = world.getBlockMetadata(x, y, z);
        int growthRate = FloweringCherryLeavesBlock.getGrowthRate(meta);
        if (world.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_SPRING) {
            if (rand.nextInt(20) == 0 && growthRate == 0) {
                world.setBlockMetadataWithNotify(x, y, z, 0x10 | meta);
                world.scheduleBlockUpdate(x, y, z, Blocks.LEAVES_CHERRY_FLOWERING.id, this.tickDelay());
            }
        } else if (growthRate > 0) {
            world.setBlockMetadataWithNotify(x, y, z, meta & 0xF);
            world.scheduleBlockUpdate(x, y, z, Blocks.LEAVES_CHERRY_FLOWERING.id, this.tickDelay());
        }
    }

    @Override
    public boolean onBonemealUsed(ItemStack itemstack, Player entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        int meta = world.getBlockMetadata(blockX, blockY, blockZ);
        if ((meta & 0xF0) >> 4 == 0) {
            if (!world.isClientSide) {
                if (world.getSeasonManager().getCurrentSeason() != Seasons.OVERWORLD_SPRING) {
                    return true;
                }
                world.setBlockMetadataWithNotify(blockX, blockY, blockZ, 0x10 | meta);
                if (entityplayer.getGamemode().consumeBlocks()) {
                    --itemstack.stackSize;
                }
            }
            return true;
        }
        return false;
    }

    public static int getGrowthRate(int meta) {
        return (meta & 0xF0) >> 4;
    }
}

