/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.Global;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.RotatableEntityBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.FurnaceBlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.ItemEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class FurnaceBlock
extends RotatableEntityBlock {
    protected Random furnaceRand = new Random();
    protected final boolean isActive;
    protected static boolean keepFurnaceInventory = false;

    public FurnaceBlock(String key, String namespaceId, int id, boolean flag) {
        super(key, namespaceId, id, Material.stone);
        this.isActive = flag;
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        super.onBlockPlacedByWorld(world, x, y, z);
        this.setDefaultDirection(world, x, y, z);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        switch (dropCause) {
            case PICK_BLOCK: 
            case EXPLOSION: 
            case PROPER_TOOL: 
            case SILK_TOUCH: {
                return new ItemStack[]{new ItemStack(Blocks.FURNACE_STONE_IDLE)};
            }
        }
        return null;
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        if (!this.isActive) {
            return;
        }
        int l = world.getBlockMetadata(x, y, z);
        double poxX = (double)x + 0.5;
        double posY = (double)y + 0.0 + (double)(rand.nextFloat() * 6.0f / 16.0f);
        double posZ = (double)z + 0.5;
        double f3 = 0.52f;
        double f4 = rand.nextFloat() * 0.6f - 0.3f;
        if (l == 4) {
            world.spawnParticle("smoke", poxX - f3, posY, posZ + f4, 0.0, 0.0, 0.0, 0);
            world.spawnParticle("flame", poxX - f3, posY, posZ + f4, 0.0, 0.0, 0.0, 0);
        } else if (l == 5) {
            world.spawnParticle("smoke", poxX + f3, posY, posZ + f4, 0.0, 0.0, 0.0, 0);
            world.spawnParticle("flame", poxX + f3, posY, posZ + f4, 0.0, 0.0, 0.0, 0);
        } else if (l == 2) {
            world.spawnParticle("smoke", poxX + f4, posY, posZ - f3, 0.0, 0.0, 0.0, 0);
            world.spawnParticle("flame", poxX + f4, posY, posZ - f3, 0.0, 0.0, 0.0, 0);
        } else if (l == 3) {
            world.spawnParticle("smoke", poxX + f4, posY, posZ + f3, 0.0, 0.0, 0.0, 0);
            world.spawnParticle("flame", poxX + f4, posY, posZ + f3, 0.0, 0.0, 0.0, 0);
        }
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (!world.isClientSide) {
            FurnaceBlockEntity tileentityfurnace = (FurnaceBlockEntity)world.getBlockEntity(x, y, z);
            player.displayGUIFurnace(tileentityfurnace);
        }
        return true;
    }

    public static void updateFurnaceBlockState(boolean lit, World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        BlockEntity tileentity = world.getBlockEntity(x, y, z);
        if (tileentity == null) {
            String msg = "Furnace is missing Tile Entity at x: " + x + " y: " + y + " z: " + z + ", block will be removed!";
            if (Global.BUILD_CHANNEL.isUnstableBuild()) {
                throw new RuntimeException(msg);
            }
            world.setBlockWithNotify(x, y, z, 0);
            System.out.println(msg);
            return;
        }
        keepFurnaceInventory = true;
        if (lit) {
            world.setBlockWithNotify(x, y, z, Blocks.FURNACE_STONE_ACTIVE.id);
        } else {
            world.setBlockWithNotify(x, y, z, Blocks.FURNACE_STONE_IDLE.id);
        }
        keepFurnaceInventory = false;
        world.setBlockMetadataWithNotify(x, y, z, meta);
        tileentity.validate();
        world.setBlockTileEntity(x, y, z, tileentity);
    }

    @Override
    protected BlockEntity getNewBlockEntity() {
        return new FurnaceBlockEntity();
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        if (!keepFurnaceInventory) {
            FurnaceBlockEntity tileentityfurnace = (FurnaceBlockEntity)world.getBlockEntity(x, y, z);
            for (int l = 0; l < tileentityfurnace.getContainerSize(); ++l) {
                ItemStack itemstack = tileentityfurnace.getItem(l);
                if (itemstack == null) continue;
                float f = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = this.furnaceRand.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    ItemEntity entityitem = new ItemEntity(world, (float)x + f, (float)y + f1, (float)z + f2, new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                    float f3 = 0.05f;
                    entityitem.xd = (float)this.furnaceRand.nextGaussian() * f3;
                    entityitem.yd = (float)this.furnaceRand.nextGaussian() * f3 + 0.2f;
                    entityitem.zd = (float)this.furnaceRand.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
        }
        super.onBlockRemoved(world, x, y, z, data);
    }
}

