/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.EntityBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.JukeboxBlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.ItemEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class JukeboxBlock
extends EntityBlock {
    public JukeboxBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.wood);
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (world.getBlockMetadata(x, y, z) == 0) {
            return false;
        }
        this.ejectRecord(world, x, y, z);
        return true;
    }

    public void playRecord(World world, int i, int j, int k, int l) {
        if (!world.isClientSide) {
            JukeboxBlockEntity tileentityrecordplayer = (JukeboxBlockEntity)world.getBlockEntity(i, j, k);
            tileentityrecordplayer.record = l;
            tileentityrecordplayer.setChanged();
            world.setBlockMetadataWithNotify(i, j, k, 1);
        }
    }

    public void ejectRecord(World world, int i, int j, int k) {
        if (world.isClientSide) {
            return;
        }
        JukeboxBlockEntity tileentityrecordplayer = (JukeboxBlockEntity)world.getBlockEntity(i, j, k);
        int l = tileentityrecordplayer.record;
        if (l != 0) {
            world.playSoundEffect(1005, i, j, k, 0);
            world.playRecord(null, null, i, j, k);
            tileentityrecordplayer.record = 0;
            tileentityrecordplayer.setChanged();
            world.setBlockMetadataWithNotify(i, j, k, 0);
            int i1 = l;
            float f = 0.7f;
            double d = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.2 + 0.6;
            double d2 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            ItemEntity entityitem = new ItemEntity(world, (double)i + d, (double)j + d1, (double)k + d2, new ItemStack(i1, 1, 0));
            entityitem.pickupDelay = 10;
            world.entityJoinedWorld(entityitem);
        }
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        this.ejectRecord(world, x, y, z);
        super.onBlockRemoved(world, x, y, z, data);
    }

    @Override
    protected BlockEntity getNewBlockEntity() {
        return new JukeboxBlockEntity();
    }
}

