/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.EntityBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.NoteBlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class NoteBlock
extends EntityBlock {
    public NoteBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.wood);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (blockId > 0 && Block.blocksList[blockId].isSignalSource()) {
            boolean flag = world.isBlockGettingPowered(x, y, z);
            NoteBlockEntity tileentitynote = (NoteBlockEntity)world.getBlockEntity(x, y, z);
            if (tileentitynote.previousRedstoneState != flag) {
                if (flag) {
                    tileentitynote.triggerNote(world, x, y, z);
                }
                tileentitynote.previousRedstoneState = flag;
            }
        }
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (world.isClientSide) {
            return true;
        }
        NoteBlockEntity tileentitynote = (NoteBlockEntity)world.getBlockEntity(x, y, z);
        tileentitynote.changePitch();
        tileentitynote.triggerNote(world, x, y, z);
        return true;
    }

    @Override
    public void onBlockLeftClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        if (world.isClientSide) {
            return;
        }
        NoteBlockEntity tileentitynote = (NoteBlockEntity)world.getBlockEntity(x, y, z);
        tileentitynote.triggerNote(world, x, y, z);
    }

    @Override
    protected BlockEntity getNewBlockEntity() {
        return new NoteBlockEntity();
    }

    @Override
    public void triggerEvent(World world, int x, int y, int z, int index, int data) {
        float f = (float)Math.pow(2.0, (double)(data - 12) / 12.0);
        String s = "harp";
        if (index == 1) {
            s = "bd";
        }
        if (index == 2) {
            s = "snare";
        }
        if (index == 3) {
            s = "hat";
        }
        if (index == 4) {
            s = "bassattack";
        }
        world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "note." + s, 3.0f, f);
        world.spawnParticle("note", (double)x + 0.5, (double)y + 1.2, (double)z + 0.5, (double)data / 24.0, 0.0, 0.0, 0);
    }
}

