/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import com.mojang.nbt.CompoundTag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.logic.PistonDirections;
import net.minecraft.core.block.piston.MovingPistonBlock;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.phys.AABB;

public class MovingPistonBlockEntity
extends BlockEntity {
    private int movedId;
    private int movedData;
    private int direction;
    private boolean extending;
    private boolean isSourcePiston;
    private float progress;
    private float progressO;
    private static List field_31018_m = new ArrayList();

    public MovingPistonBlockEntity() {
    }

    public MovingPistonBlockEntity(int movedId, int movedData, int direction, boolean extending, boolean isSourcePiston) {
        this.movedId = movedId;
        this.movedData = movedData;
        this.direction = direction;
        this.extending = extending;
        this.isSourcePiston = isSourcePiston;
    }

    public int getMovedId() {
        return this.movedId;
    }

    @Override
    public int getMovedData() {
        return this.movedData;
    }

    public boolean isExtending() {
        return this.extending;
    }

    public int getDirection() {
        return this.direction;
    }

    public boolean isSourcePiston() {
        return this.isSourcePiston;
    }

    public float getProgress(float partialTick) {
        if (partialTick > 1.0f) {
            partialTick = 1.0f;
        }
        return this.progressO + (this.progress - this.progressO) * partialTick;
    }

    public float getXOff(float partialTick) {
        if (this.extending) {
            return (this.getProgress(partialTick) - 1.0f) * (float)PistonDirections.xOffset[this.direction];
        }
        return (1.0f - this.getProgress(partialTick)) * (float)PistonDirections.xOffset[this.direction];
    }

    public float getYOff(float partialTick) {
        if (this.extending) {
            return (this.getProgress(partialTick) - 1.0f) * (float)PistonDirections.yOffset[this.direction];
        }
        return (1.0f - this.getProgress(partialTick)) * (float)PistonDirections.yOffset[this.direction];
    }

    public float getZOff(float partialTick) {
        if (this.extending) {
            return (this.getProgress(partialTick) - 1.0f) * (float)PistonDirections.zOffset[this.direction];
        }
        return (1.0f - this.getProgress(partialTick)) * (float)PistonDirections.zOffset[this.direction];
    }

    private void moveCollidedEntities(float f, float f1) {
        List<Entity> list;
        f = !this.extending ? (f -= 1.0f) : 1.0f - f;
        AABB axisalignedbb = ((MovingPistonBlock)Blocks.PISTON_MOVING).getCollisionShapeFromTileEntity(this.worldObj, this.x, this.y, this.z, this.movedId, f, this.direction);
        if (axisalignedbb != null && !(list = this.worldObj.getEntitiesWithinAABBExcludingEntity(null, axisalignedbb)).isEmpty()) {
            field_31018_m.addAll(list);
            Entity entity = null;
            Iterator iterator = field_31018_m.iterator();
            do {
                if ((entity = (Entity)iterator.next()) == null || entity.noPhysics) continue;
                entity.move(f1 * (float)PistonDirections.xOffset[this.direction], f1 * (float)PistonDirections.yOffset[this.direction], f1 * (float)PistonDirections.zOffset[this.direction]);
            } while (iterator.hasNext());
            field_31018_m.clear();
        }
    }

    public void finalTick() {
        if (this.progressO < 1.0f) {
            this.progress = 1.0f;
            this.progressO = 1.0f;
            this.worldObj.removeBlockTileEntity(this.x, this.y, this.z);
            this.invalidate();
            if (this.worldObj.getBlockId(this.x, this.y, this.z) == Blocks.PISTON_MOVING.id) {
                this.worldObj.setBlockAndMetadataWithNotify(this.x, this.y, this.z, this.movedId, this.movedData);
            }
        }
    }

    @Override
    public void tick() {
        this.progressO = this.progress;
        if (this.progressO >= 1.0f) {
            this.moveCollidedEntities(1.0f, 0.25f);
            this.worldObj.removeBlockTileEntity(this.x, this.y, this.z);
            this.invalidate();
            if (this.worldObj.getBlockId(this.x, this.y, this.z) == Blocks.PISTON_MOVING.id) {
                this.worldObj.setBlockAndMetadataWithNotify(this.x, this.y, this.z, this.movedId, this.movedData);
            }
            return;
        }
        this.progress += 0.5f;
        if (this.progress >= 1.0f) {
            this.progress = 1.0f;
        }
        if (this.extending) {
            this.moveCollidedEntities(this.progress, this.progress - this.progressO + 0.0625f);
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.movedId = tag.getInteger("blockId");
        this.movedData = tag.getInteger("blockData");
        this.direction = tag.getInteger("facing");
        this.progressO = this.progress = tag.getFloat("progress");
        this.extending = tag.getBoolean("extending");
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.putInt("blockId", this.movedId);
        tag.putInt("blockData", this.movedData);
        tag.putInt("facing", this.direction);
        tag.putFloat("progress", this.progressO);
        tag.putBoolean("extending", this.extending);
    }
}

