/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data;

import com.b100.utils.FileUtils;
import com.b100.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.core.MinecraftAccessor;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.HasJsonAdapter;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.adapter.ItemStackJsonAdapter;
import net.minecraft.core.data.registry.recipe.adapter.RecipeJsonAdapter;
import net.minecraft.core.data.registry.recipe.adapter.RecipeSymbolJsonAdapter;
import net.minecraft.core.data.registry.recipe.adapter.WeightedRandomBagJsonAdapter;
import net.minecraft.core.data.registry.recipe.adapter.WeightedRandomLootObjectJsonAdapter;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.packet.RecipeSyncPacket;

public class DataLoader {
    public static void loadItemGroupsFromString(String json) {
        int i = 0;
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter((Type)((Object)ItemStack.class), new ItemStackJsonAdapter());
        builder.registerTypeAdapter((Type)((Object)RecipeSymbol.class), new RecipeSymbolJsonAdapter());
        Gson gson = builder.create();
        JsonObject jsonObject = JsonParser.parseString(json).getAsJsonObject();
        for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
            List stacks = (List)gson.fromJson(entry.getValue(), new TypeToken<List<ItemStack>>(){}.getType());
            Registries.ITEM_GROUPS.register(entry.getKey(), stacks);
            ++i;
        }
        System.out.printf("Registered %d item groups%n", i);
    }

    public static void loadItemGroupsFromFile(String path) {
        int i = 0;
        String jsonString = StringUtils.readInputString(DataLoader.class.getResourceAsStream(path));
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter((Type)((Object)ItemStack.class), new ItemStackJsonAdapter());
        builder.registerTypeAdapter((Type)((Object)RecipeSymbol.class), new RecipeSymbolJsonAdapter());
        Gson gson = builder.create();
        JsonObject jsonObject = JsonParser.parseString(jsonString).getAsJsonObject();
        for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
            List stacks = (List)gson.fromJson(entry.getValue(), new TypeToken<List<ItemStack>>(){}.getType());
            Registries.ITEM_GROUPS.register(entry.getKey(), stacks);
            ++i;
        }
        System.out.printf("Registered %d item groups from %s%n", i, path);
    }

    public static void loadDataPacks(MinecraftAccessor mc) {
        File[] filesInDir;
        File dataDir = new File(mc.getMinecraftDir(), "datapacks");
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        if (dataDir.exists() && dataDir.isDirectory() && (filesInDir = dataDir.listFiles()) != null) {
            for (File file : filesInDir) {
                if (!file.getName().toLowerCase().endsWith(".zip")) continue;
                try (ZipFile zipFile = new ZipFile(file);){
                    System.out.printf("Loading data from %s%n", file.getName());
                    ZipEntry manifestEntry = zipFile.getEntry("manifest.json");
                    if (manifestEntry == null) continue;
                    try (InputStreamReader reader = new InputStreamReader(zipFile.getInputStream(manifestEntry));){
                        String contents;
                        InputStream recipeFileInputStream;
                        Gson gson = new Gson();
                        TypeToken<Map<String, List<String>>> token = new TypeToken<Map<String, List<String>>>(){};
                        Map<String, List<String>> map = gson.fromJson((Reader)reader, token);
                        List<String> recipeFiles = map.get("added_recipes");
                        List<String> groupFiles = map.get("added_item_groups");
                        List<String> removedRecipes = map.get("removed_recipes");
                        if (removedRecipes != null && !removedRecipes.isEmpty()) {
                            for (String removedRecipe : removedRecipes) {
                                String[] deconstructedKey = Registries.RECIPES.deconstructKey(removedRecipe);
                                Registries.RECIPES.getGroupFromKey(removedRecipe).unregister(deconstructedKey[2]);
                            }
                            System.out.printf("Removed %d recipes%n", removedRecipes.size());
                        }
                        if (groupFiles != null && !groupFiles.isEmpty()) {
                            for (String groupFile : groupFiles) {
                                ZipEntry groupFileEntry = zipFile.getEntry(groupFile);
                                if (groupFileEntry == null) continue;
                                recipeFileInputStream = zipFile.getInputStream(groupFileEntry);
                                try {
                                    contents = StringUtils.readInputString(recipeFileInputStream);
                                    System.out.printf("Loading item groups from %s/%s%n", file.getName(), groupFile);
                                    DataLoader.loadItemGroupsFromString(contents);
                                }
                                finally {
                                    if (recipeFileInputStream != null) {
                                        recipeFileInputStream.close();
                                    }
                                }
                            }
                        }
                        if (recipeFiles == null || recipeFiles.isEmpty()) continue;
                        for (String recipeFile : recipeFiles) {
                            ZipEntry recipeFileEntry = zipFile.getEntry(recipeFile);
                            if (recipeFileEntry == null) continue;
                            recipeFileInputStream = zipFile.getInputStream(recipeFileEntry);
                            try {
                                contents = StringUtils.readInputString(recipeFileInputStream);
                                System.out.printf("Loading recipes from %s/%s%n", file.getName(), recipeFile);
                                DataLoader.loadRecipesFromString(contents);
                            }
                            finally {
                                if (recipeFileInputStream == null) continue;
                                recipeFileInputStream.close();
                            }
                        }
                    }
                }
                catch (IOException | RuntimeException e) {
                    System.err.println("Failed to load data from " + file.getName());
                    e.printStackTrace();
                }
            }
        }
    }

    public static void loadRecipesFromFile(String path) {
        int i = 0;
        String jsonString = StringUtils.readInputString(DataLoader.class.getResourceAsStream(path));
        JsonArray jsonArray = JsonParser.parseString(jsonString).getAsJsonArray();
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        ArrayList usedAdapters = new ArrayList();
        for (JsonElement element : jsonArray) {
            if (element.isJsonNull()) continue;
            JsonObject recipeJson = element.getAsJsonObject();
            String recipeTypeId = recipeJson.get("type").getAsString();
            String recipeId = recipeJson.get("name").getAsString();
            Class<RecipeEntryBase<?, ?, ?>> recipeEntryClass = Registries.RECIPE_TYPES.getItem(recipeTypeId);
            if (Arrays.asList(recipeEntryClass.getInterfaces()).contains(HasJsonAdapter.class)) {
                try {
                    RecipeEntryBase<?, ?, ?> recipeEntryPrototype = recipeEntryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    RecipeJsonAdapter<?> adapter = ((HasJsonAdapter)((Object)recipeEntryPrototype)).getAdapter();
                    if (!usedAdapters.contains(adapter)) {
                        builder.registerTypeAdapter(recipeEntryClass, adapter);
                        usedAdapters.add(adapter);
                    }
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            builder.registerTypeAdapter((Type)((Object)ItemStack.class), new ItemStackJsonAdapter());
            builder.registerTypeAdapter((Type)((Object)RecipeSymbol.class), new RecipeSymbolJsonAdapter());
            builder.registerTypeAdapter(new TypeToken<WeightedRandomBag<WeightedRandomLootObject>>(){}.getType(), new WeightedRandomBagJsonAdapter());
            builder.registerTypeAdapter((Type)((Object)WeightedRandomLootObject.class), new WeightedRandomLootObjectJsonAdapter());
            Gson gson = builder.create();
            RecipeEntryBase<?, ?, ?> recipe = gson.fromJson((JsonElement)recipeJson, recipeEntryClass);
            Registries.RECIPES.addCustomRecipe(recipeId, recipe);
            ++i;
        }
        System.out.printf("Registered %d recipes from %s%n", i, path);
    }

    public static void loadRecipesFromString(String json) {
        int i = 0;
        JsonArray jsonArray = JsonParser.parseString(json).getAsJsonArray();
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        ArrayList usedAdapters = new ArrayList();
        for (JsonElement element : jsonArray) {
            if (element.isJsonNull()) continue;
            JsonObject recipeJson = element.getAsJsonObject();
            String recipeTypeId = recipeJson.get("type").getAsString();
            String recipeId = recipeJson.get("name").getAsString();
            Class<RecipeEntryBase<?, ?, ?>> recipeEntryClass = Registries.RECIPE_TYPES.getItem(recipeTypeId);
            if (Arrays.asList(recipeEntryClass.getInterfaces()).contains(HasJsonAdapter.class)) {
                try {
                    RecipeEntryBase<?, ?, ?> recipeEntryPrototype = recipeEntryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    RecipeJsonAdapter<?> adapter = ((HasJsonAdapter)((Object)recipeEntryPrototype)).getAdapter();
                    if (!usedAdapters.contains(adapter)) {
                        builder.registerTypeAdapter(recipeEntryClass, adapter);
                        usedAdapters.add(adapter);
                    }
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            builder.registerTypeAdapter((Type)((Object)ItemStack.class), new ItemStackJsonAdapter());
            builder.registerTypeAdapter((Type)((Object)RecipeSymbol.class), new RecipeSymbolJsonAdapter());
            builder.registerTypeAdapter(new TypeToken<WeightedRandomBag<WeightedRandomLootObject>>(){}.getType(), new WeightedRandomBagJsonAdapter());
            builder.registerTypeAdapter((Type)((Object)WeightedRandomLootObject.class), new WeightedRandomLootObjectJsonAdapter());
            Gson gson = builder.create();
            RecipeEntryBase<?, ?, ?> recipe = gson.fromJson((JsonElement)recipeJson, recipeEntryClass);
            Registries.RECIPES.addCustomRecipe(recipeId, recipe);
            ++i;
        }
        System.out.printf("Registered %d recipes%n", i);
    }

    public static void loadRecipeFromServer(RecipeSyncPacket packet) {
        JsonArray jsonArray = JsonParser.parseString(packet.recipe).getAsJsonArray();
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        JsonElement element = jsonArray.get(0);
        if (element.isJsonNull()) {
            return;
        }
        JsonObject recipeJson = element.getAsJsonObject();
        String recipeTypeId = recipeJson.get("type").getAsString();
        String recipeId = recipeJson.get("name").getAsString();
        Class<RecipeEntryBase<?, ?, ?>> recipeEntryClass = Registries.RECIPE_TYPES.getItem(recipeTypeId);
        if (Arrays.asList(recipeEntryClass.getInterfaces()).contains(HasJsonAdapter.class)) {
            try {
                RecipeEntryBase<?, ?, ?> recipeEntryPrototype = recipeEntryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                RecipeJsonAdapter<?> adapter = ((HasJsonAdapter)((Object)recipeEntryPrototype)).getAdapter();
                builder.registerTypeAdapter(recipeEntryClass, adapter);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        builder.registerTypeAdapter((Type)((Object)ItemStack.class), new ItemStackJsonAdapter());
        builder.registerTypeAdapter((Type)((Object)RecipeSymbol.class), new RecipeSymbolJsonAdapter());
        builder.registerTypeAdapter(new TypeToken<WeightedRandomBag<WeightedRandomLootObject>>(){}.getType(), new WeightedRandomBagJsonAdapter());
        builder.registerTypeAdapter((Type)((Object)WeightedRandomLootObject.class), new WeightedRandomLootObjectJsonAdapter());
        Gson gson = builder.create();
        RecipeEntryBase<?, ?, ?> recipe = gson.fromJson((JsonElement)recipeJson, recipeEntryClass);
        Registries.RECIPES.addCustomRecipe(recipeId, recipe);
    }

    public static String serializeRecipes() {
        List<RecipeEntryBase<?, ?, ?>> recipes = Registries.RECIPES.getAllSerializableRecipes();
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        ArrayList usedAdapters = new ArrayList();
        for (RecipeEntryBase<?, ?, ?> recipe : recipes) {
            HasJsonAdapter hasJsonAdapter = (HasJsonAdapter)((Object)recipe);
            RecipeJsonAdapter<?> adapter = hasJsonAdapter.getAdapter();
            if (usedAdapters.contains(adapter)) continue;
            builder.registerTypeAdapter(recipe.getClass(), adapter);
            usedAdapters.add(adapter);
        }
        builder.registerTypeAdapter((Type)((Object)ItemStack.class), new ItemStackJsonAdapter());
        builder.registerTypeAdapter((Type)((Object)RecipeSymbol.class), new RecipeSymbolJsonAdapter());
        builder.registerTypeAdapter(new TypeToken<WeightedRandomBag<WeightedRandomLootObject>>(){}.getType(), new WeightedRandomBagJsonAdapter());
        builder.registerTypeAdapter((Type)((Object)WeightedRandomLootObject.class), new WeightedRandomLootObjectJsonAdapter());
        Gson gson = builder.create();
        JsonArray jsonArray = new JsonArray();
        for (RecipeEntryBase<?, ?, ?> recipe : recipes) {
            TypeAdapter<?> typeAdapter = gson.getAdapter(recipe.getClass());
            JsonElement json = typeAdapter.toJsonTree(recipe);
            jsonArray.add(json);
        }
        return gson.toJson(jsonArray);
    }

    public static String serializeRecipe(RecipeEntryBase<?, ?, ?> recipe) {
        if (!(recipe instanceof HasJsonAdapter)) {
            throw new IllegalArgumentException("Recipe cannot be serialized!");
        }
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        HasJsonAdapter hasJsonAdapter = (HasJsonAdapter)((Object)recipe);
        RecipeJsonAdapter<?> adapter = hasJsonAdapter.getAdapter();
        builder.registerTypeAdapter(recipe.getClass(), adapter);
        builder.registerTypeAdapter((Type)((Object)ItemStack.class), new ItemStackJsonAdapter());
        builder.registerTypeAdapter((Type)((Object)RecipeSymbol.class), new RecipeSymbolJsonAdapter());
        builder.registerTypeAdapter(new TypeToken<WeightedRandomBag<WeightedRandomLootObject>>(){}.getType(), new WeightedRandomBagJsonAdapter());
        builder.registerTypeAdapter((Type)((Object)WeightedRandomLootObject.class), new WeightedRandomLootObjectJsonAdapter());
        Gson gson = builder.create();
        JsonArray jsonArray = new JsonArray();
        TypeAdapter<?> typeAdapter = gson.getAdapter(recipe.getClass());
        jsonArray.add(typeAdapter.toJsonTree(recipe));
        return gson.toJson(jsonArray);
    }

    public static void exportRecipes(String path) {
        List<RecipeEntryBase<?, ?, ?>> recipes = Registries.RECIPES.getAllSerializableRecipes();
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        ArrayList usedAdapters = new ArrayList();
        for (RecipeEntryBase<?, ?, ?> recipe : recipes) {
            HasJsonAdapter hasJsonAdapter = (HasJsonAdapter)((Object)recipe);
            RecipeJsonAdapter<?> recipeJsonAdapter = hasJsonAdapter.getAdapter();
            if (usedAdapters.contains(recipeJsonAdapter)) continue;
            builder.registerTypeAdapter(recipe.getClass(), recipeJsonAdapter);
            usedAdapters.add(recipeJsonAdapter);
        }
        builder.registerTypeAdapter((Type)((Object)ItemStack.class), new ItemStackJsonAdapter());
        builder.registerTypeAdapter((Type)((Object)RecipeSymbol.class), new RecipeSymbolJsonAdapter());
        builder.registerTypeAdapter(new TypeToken<WeightedRandomBag<WeightedRandomLootObject>>(){}.getType(), new WeightedRandomBagJsonAdapter());
        builder.registerTypeAdapter((Type)((Object)WeightedRandomLootObject.class), new WeightedRandomLootObjectJsonAdapter());
        Gson gson = builder.create();
        JsonArray jsonArray = new JsonArray();
        for (RecipeEntryBase recipeEntryBase : recipes) {
            TypeAdapter<?> typeAdapter = gson.getAdapter(recipeEntryBase.getClass());
            JsonElement json = typeAdapter.toJsonTree(recipeEntryBase);
            jsonArray.add(json);
        }
        File file = FileUtils.createNewFile(new File(path));
        try (FileWriter fileWriter = new FileWriter(file);){
            gson.toJson((JsonElement)jsonArray, (Appendable)fileWriter);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

