/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.SignBlockEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class SignItem
extends Item {
    public SignItem(String name, String namespaceId, int id) {
        super(name, namespaceId, id);
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack itemstack, Player entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        int sideHit = side.getId();
        if (side == Side.BOTTOM) {
            return false;
        }
        if (!world.getBlockMaterial(blockX, blockY, blockZ).isSolid()) {
            return false;
        }
        if (!world.canPlaceInsideBlock(blockX, blockY, blockZ)) {
            blockX += side.getOffsetX();
            blockY += side.getOffsetY();
            blockZ += side.getOffsetZ();
        }
        if (blockY < 0 || blockY >= world.getHeightBlocks()) {
            return false;
        }
        if (!Blocks.SIGN_POST_PLANKS_OAK.canPlaceBlockAt(world, blockX, blockY, blockZ)) {
            return false;
        }
        if (sideHit == 1) {
            world.playBlockSoundEffect(entityplayer, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, Blocks.SIGN_POST_PLANKS_OAK, EnumBlockSoundEffectType.PLACE);
            world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Blocks.SIGN_POST_PLANKS_OAK.id, MathHelper.floor((double)((entityplayer.yRot + 180.0f) * 16.0f / 360.0f) + 0.5) & 0xF);
        } else {
            world.playBlockSoundEffect(entityplayer, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, Blocks.SIGN_WALL_PLANKS_OAK, EnumBlockSoundEffectType.PLACE);
            world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Blocks.SIGN_WALL_PLANKS_OAK.id, sideHit);
        }
        itemstack.consumeItem(entityplayer);
        SignBlockEntity tileentitysign = (SignBlockEntity)world.getBlockEntity(blockX, blockY, blockZ);
        if (tileentitysign != null) {
            tileentitysign.setOwner(entityplayer);
            entityplayer.displayGUIEditSign(tileentitysign);
        }
        return true;
    }
}

