/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.util.helper.DamageType;

public class HarmCommand
extends Command {
    public HarmCommand() {
        super("harm", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length == 0) {
            Player player = sender.getPlayer();
            player.hurt(player, 1, DamageType.GENERIC);
            sender.sendMessage("Harmed player " + player.getDisplayName() + "for 1");
            return true;
        }
        if (args.length == 1) {
            Player player = handler.getPlayer(args[0]);
            if (player == null) {
                return false;
            }
            player.hurt(player, 1, DamageType.GENERIC);
            sender.sendMessage("Harmed player " + player.getDisplayName() + "for 1");
            return true;
        }
        if (args.length == 2) {
            Player player = handler.getPlayer(args[0]);
            int damageAmount = this.parseInt(args[1]);
            if (player == null) {
                return false;
            }
            player.hurt(player, damageAmount, DamageType.GENERIC);
            sender.sendMessage("Harmed player " + player.getDisplayName() + "for " + damageAmount);
            return true;
        }
        return false;
    }

    public int parseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            throw new CommandError("Not an integer: \"" + str + "\"");
        }
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/harm");
        sender.sendMessage("/harm <username> <amount>");
    }
}

