/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import java.util.Collection;
import java.util.Locale;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.world.SpawnerMobs;
import net.minecraft.core.world.World;

public class MobSpawningCommand
extends Command {
    public MobSpawningCommand() {
        super("mobspawning", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length == 0) {
            return false;
        }
        World world = handler.getWorld(0);
        SpawnerMobs.SpawnerConfig config = world.spawningConfig;
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "list": {
                Collection<String> ids = EntityDispatcher.classToKeyMap.values();
                for (String s : ids) {
                    sender.sendMessage(String.format("%s : %s", s, config.canMobSpawn(s)));
                }
                sender.sendMessage("Passive Spawning : " + config.canPassiveSpawn(world));
                sender.sendMessage("Hostile Spawning : " + config.canHostileSpawn(world));
                return true;
            }
            case "set": {
                if (args.length != 3) {
                    return false;
                }
                String mobId = args[1];
                boolean value = Boolean.parseBoolean(args[2].toLowerCase(Locale.ROOT));
                config.setMobSpawn(mobId, value);
                sender.sendMessage(String.format("Set '%s' to '%s'", mobId, value));
                return true;
            }
            case "passive": {
                if (args.length != 2) {
                    return false;
                }
                boolean value = Boolean.parseBoolean(args[1].toLowerCase(Locale.ROOT));
                config.setPassiveSpawning(value);
                sender.sendMessage(String.format("Passive spawning to '%s'", value));
                return true;
            }
            case "hostile": {
                if (args.length != 2) {
                    return false;
                }
                boolean value = Boolean.parseBoolean(args[1].toLowerCase(Locale.ROOT));
                config.setHostileSpawning(value);
                sender.sendMessage(String.format("Hostile spawning to '%s'", value));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/mobspawning list");
        sender.sendMessage("/mobspawning set <id> <value>");
        sender.sendMessage("/mobspawning passive <value>");
        sender.sendMessage("/mobspawning hostile <value>");
    }
}

