/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.servercommands;

import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.ServerCommand;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.ServerPlayer;

public class KickCommand
extends ServerCommand {
    public KickCommand(MinecraftServer server) {
        super(server, "kick", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length != 1) {
            return false;
        }
        String senderName = sender.getName();
        String nameToKick = args[0];
        ServerPlayer playerToKick = null;
        for (ServerPlayer playerMP : this.server.playerList.playerEntities) {
            if (!playerMP.username.equalsIgnoreCase(nameToKick)) continue;
            playerToKick = playerMP;
            break;
        }
        if (playerToKick != null) {
            playerToKick.playerNetServerHandler.kickPlayer("Kicked by admin");
            this.sendNoticeToOps(senderName, "Kicking " + playerToKick.getDisplayName());
        } else {
            this.server.log("Can't find user " + nameToKick + ". No kick attempted.");
        }
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/kick <username>");
    }
}

