/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import net.minecraft.client.Minecraft;

public class GameResolution {
    public static int defaultWidth = 854;
    public static int defaultHeight = 480;
    public final Minecraft minecraft;
    public int width;
    public int height;
    public int scale;
    public int scaledWidth;
    public int scaledHeight;
    public double scaledWidthExact;
    public double scaledHeightExact;

    public GameResolution(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public void update() {
        this.width = this.minecraft.gameWindow.getWidth();
        this.height = this.minecraft.gameWindow.getHeight();
        this.setSize(this.width, this.height);
        if (this.minecraft.controllerInput != null) {
            this.minecraft.controllerInput.cursorX = (float)this.scaledWidth / 2.0f;
            this.minecraft.controllerInput.cursorY = (float)this.scaledHeight / 2.0f;
        }
    }

    public void setSize(int w, int h) {
        this.width = Math.max(w, 1);
        this.height = Math.max(h, 1);
        this.scale = GameResolution.getMaxScale(this.width, this.height);
        int setScale = this.getSetGuiScale();
        if (setScale > 0) {
            this.scale = Math.min(this.scale, setScale);
        }
        double dscale = this.scale;
        this.scaledWidthExact = (double)this.width / dscale;
        this.scaledHeightExact = (double)this.height / dscale;
        this.scaledWidth = (int)Math.ceil(this.scaledWidthExact);
        this.scaledHeight = (int)Math.ceil(this.scaledHeightExact);
        this.scaledWidth = Math.max(this.scaledWidth, 1);
        this.scaledHeight = Math.max(this.scaledHeight, 1);
    }

    public int getSetGuiScale() {
        if (this.minecraft.gameSettings != null) {
            return (Integer)this.minecraft.gameSettings.guiScale.value;
        }
        return 0;
    }

    public int getMaxScale() {
        return GameResolution.getMaxScale(this.width, this.height);
    }

    public static int getMaxScale(int width, int height) {
        return Math.max(Math.min(width / 320, height / 240), 1);
    }
}

