/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiPhotoMode;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiStats;
import net.minecraft.client.gui.achievements.GuiAchievements;
import net.minecraft.client.gui.guidebook.GuiGuidebook;
import net.minecraft.client.gui.guidebook.PageManager;
import net.minecraft.client.gui.guidebook.search.SearchPage;
import net.minecraft.client.gui.options.GuiOptions;
import net.minecraft.client.gui.options.data.OptionsPages;
import net.minecraft.client.input.InputType;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.util.helper.MathHelper;

public class GuiIngameMenu
extends GuiScreen {
    private int updateCounter2 = 0;
    private int updateCounter = 0;
    public static boolean photoModeDisabled = false;

    @Override
    public void init() {
        I18n i = I18n.getInstance();
        this.updateCounter2 = 0;
        this.controlList.clear();
        int byte0 = -16;
        this.controlList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 120 + byte0, i.translateKey("gui.ingame_menu.button.save_and_quit")));
        if (this.mc.isMultiplayerWorld()) {
            ((GuiButton)this.controlList.get((int)0)).displayString = i.translateKey("gui.ingame_menu.button.disconnect");
        }
        this.controlList.add(new GuiButton(4, this.width / 2 - 100, this.height / 4 + 24 + byte0, i.translateKey("gui.ingame_menu.button.back_to_game")));
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 96 + byte0, 98, 20, i.translateKey("gui.ingame_menu.button.options")));
        GuiButton photoModeButton = new GuiButton(7, this.width / 2 + 2, this.height / 4 + 96 + byte0, 98, 20, i.translateKey("gui.ingame_menu.button.photo_mode"));
        this.controlList.add(photoModeButton);
        if (photoModeDisabled) {
            photoModeButton.enabled = false;
        }
        this.controlList.add(new GuiButton(5, this.width / 2 - 100, this.height / 4 + 48 + byte0, 98, 20, I18n.getInstance().translateKey("gui.ingame_menu.button.achievements")));
        this.controlList.add(new GuiButton(6, this.width / 2 + 2, this.height / 4 + 48 + byte0, 98, 20, I18n.getInstance().translateKey("gui.ingame_menu.button.statistics")));
        GuiButton debugButton = new GuiButton(9, this.width - 8, this.height - 8, 8, 8, "");
        debugButton.visible = false;
        this.controlList.add(debugButton);
    }

    @Override
    protected void buttonPressed(GuiButton button) {
        if (button.id == 0) {
            this.mc.displayGuiScreen(new GuiOptions(this));
        }
        if (button.id == 1) {
            this.mc.statsCounter.add(StatList.leaveGameStat, 1);
            if (this.mc.isMultiplayerWorld()) {
                this.mc.theWorld.sendQuittingDisconnectingPacket();
                Registries.RECIPES = Registries.RECIPES_LOCAL_COPY;
                SearchPage.searchField.setText("");
                PageManager.searchQuery = SearchQuery.resolve(SearchPage.searchField.getText());
                GuiGuidebook.getPageManager().updatePages();
            }
            this.mc.changeWorld(null);
            this.mc.displayGuiScreen(new GuiMainMenu());
        }
        if (button.id == 4) {
            this.mc.displayGuiScreen(null);
            this.mc.setIngameFocus();
            if (this.mc.inputType == InputType.CONTROLLER) {
                this.mc.controllerInput.buttonA.cancelButtonPress();
            }
        }
        if (button.id == 5) {
            this.mc.displayGuiScreen(new GuiAchievements(this, this.mc.statsCounter));
        }
        if (button.id == 6) {
            this.mc.displayGuiScreen(new GuiStats(this, this.mc.statsCounter));
        }
        if (button.id == 7) {
            this.mc.displayGuiScreen(new GuiPhotoMode());
        }
        if (button.id == 9) {
            this.mc.displayGuiScreen(new GuiOptions(this, OptionsPages.DEBUG));
        }
    }

    @Override
    public void tick() {
        super.tick();
        ++this.updateCounter;
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        boolean isSaving;
        I18n i = I18n.getInstance();
        this.drawDefaultBackground();
        if (this.mc == null || this.mc.theWorld == null) {
            this.mc.displayGuiScreen(null);
            return;
        }
        boolean bl = isSaving = !this.mc.theWorld.pauseScreenSave(this.updateCounter2++);
        if (isSaving || this.updateCounter < 20) {
            float f1 = ((float)(this.updateCounter % 10) + partialTick) / 10.0f;
            f1 = MathHelper.sin(f1 * (float)Math.PI * 2.0f) * 0.2f + 0.8f;
            int k = (int)(255.0f * f1);
            this.drawString(this.fontRenderer, i.translateKey("gui.ingame_menu.label.saving"), 8, this.height - 16, k << 16 | k << 8 | k);
        }
        this.drawStringCentered(this.fontRenderer, i.translateKey("gui.ingame_menu.label.title"), this.width / 2, 40, 0xFFFFFF);
        String score = TextFormatting.YELLOW.toString() + this.mc.thePlayer.getScore();
        this.drawStringCentered(this.fontRenderer, i.translateKeyAndFormat("gui.ingame_menu.label.score", score), this.width / 2, 56, 0xFEFEFE);
        super.drawScreen(mouseX, mouseY, partialTick);
    }
}

