/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.modelviewer.GuiModelViewer;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntry;
import net.minecraft.client.gui.modelviewer.elements.GuiListSelectorButton;
import net.minecraft.client.gui.modelviewer.elements.GuiListenerButton;
import net.minecraft.client.gui.modelviewer.elements.GuiTextCycle;
import net.minecraft.core.entity.animal.WolfMob;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ArmorMaterial;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntityWolfEntry
extends EntityEntry<WolfMob> {
    private static final List<ArmorMaterial> armorMaterials = new ArrayList<ArmorMaterial>(WolfMob.ARMOR_MATERIALS.keySet());

    @Override
    public void onTick(WolfMob entity) {
    }

    @Override
    public List<GuiButton> getEntryButtons(Minecraft mc, GuiScreen parentScreen, final WolfMob entityWolf) {
        ArrayList<GuiButton> buttonList = new ArrayList<GuiButton>();
        boolean isTamed = entityWolf.isWolfTamed();
        GuiListenerButton tamed = new GuiListenerButton(-1, -120, 0, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.entity.wolf.button.tamed", isTamed));
        tamed.setActionListener(() -> {
            boolean _tamed = !entityWolf.isWolfTamed();
            entityWolf.setWolfTamed(_tamed);
            tamed.displayString = I18n.getInstance().translateKeyAndFormat("model.category.entity.wolf.button.tamed", _tamed);
        });
        boolean isSitting = entityWolf.isWolfSitting();
        GuiListenerButton sitting = new GuiListenerButton(-1, -120, tamed.yPosition + 21, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.entity.wolf.button.sitting", isSitting));
        sitting.setActionListener(() -> {
            boolean _sitting = !entityWolf.isWolfSitting();
            entityWolf.setWolfSitting(_sitting);
            sitting.displayString = I18n.getInstance().translateKeyAndFormat("model.category.entity.wolf.button.sitting", _sitting);
        });
        boolean isAngry = entityWolf.isWolfAngry();
        GuiListenerButton angry = new GuiListenerButton(-1, -120, sitting.yPosition + 21, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.entity.wolf.button.angry", isAngry));
        angry.setActionListener(() -> {
            boolean _angry = !entityWolf.isWolfAngry();
            entityWolf.setWolfAngry(_angry);
            angry.displayString = I18n.getInstance().translateKeyAndFormat("model.category.entity.wolf.button.angry", _angry);
        });
        GuiListSelectorButton<ArmorMaterial> armor = new GuiListSelectorButton<ArmorMaterial>(-1, -120, angry.yPosition + 21, 120, 20, I18n.getInstance().translateKey("model.category.entity.wolf.button.armor"), armorMaterials, null){

            @Override
            public String getNameFromElement(ArmorMaterial element) {
                return element == null ? "none" : element.identifier.toString();
            }
        };
        armor.setActionListener(() -> {
            ArmorMaterial material = (ArmorMaterial)armor.getCurrentElement();
            entityWolf.getEntityData().set(19, material == null ? "" : material.identifier.toString());
        });
        entityWolf.setWolfHeldItem(null);
        GuiListenerButton hasItem = new GuiListenerButton(-1, -120, armor.yPosition + 21, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.entity.wolf.button.item", false));
        GuiTextCycle<Integer> itemIdCycle = new GuiTextCycle<Integer>(parentScreen, mc.fontRenderer, -120, hasItem.yPosition + 21, 120, 20, Integer.valueOf(1)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return GuiModelViewer.cycleItemId(current, offset);
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = Integer.parseInt(s);
                    if (Item.itemsList[id] != null) {
                        return id;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (entityWolf.getWolfHeldItem() != null) {
                    return entityWolf.getWolfHeldItem().itemID;
                }
                return 0;
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        itemIdCycle.enabled = false;
        itemIdCycle.textField.setPrefaceText("ID: ");
        itemIdCycle.textField.setPlaceholder("Item ID");
        GuiTextCycle<Integer> metaCycle = new GuiTextCycle<Integer>(parentScreen, mc.fontRenderer, -120, itemIdCycle.yPosition + 21, 120, 20, Integer.valueOf(0)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return current + offset & 0x3FFF;
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = Integer.parseInt(s);
                    return MathHelper.clamp(id, 0, 16383);
                }
                catch (Exception exception) {
                    if (entityWolf.getWolfHeldItem() != null) {
                        return entityWolf.getWolfHeldItem().getMetadata();
                    }
                    return 0;
                }
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        metaCycle.enabled = false;
        metaCycle.textField.setPrefaceText("Meta: ");
        metaCycle.textField.setPlaceholder("Meta");
        itemIdCycle.setOnValueChanged(() -> entityWolf.setWolfHeldItem(new ItemStack((Integer)itemIdCycle.getCurrentElement(), 1, (int)((Integer)metaCycle.getCurrentElement()))));
        metaCycle.setOnValueChanged(() -> entityWolf.setWolfHeldItem(new ItemStack((Integer)itemIdCycle.getCurrentElement(), 1, (int)((Integer)metaCycle.getCurrentElement()))));
        hasItem.setActionListener(() -> {
            boolean _hasItem;
            boolean bl = _hasItem = entityWolf.getWolfHeldItem() != null;
            if (_hasItem) {
                entityWolf.setWolfHeldItem(null);
                itemIdCycle.enabled = false;
                metaCycle.enabled = false;
            } else {
                entityWolf.setWolfHeldItem(new ItemStack((Integer)itemIdCycle.getCurrentElement(), 1, (int)((Integer)metaCycle.getCurrentElement())));
                itemIdCycle.enabled = true;
                metaCycle.enabled = true;
            }
            hasItem.displayString = I18n.getInstance().translateKeyAndFormat("model.category.entity.wolf.button.item", !_hasItem);
        });
        buttonList.add(tamed);
        buttonList.add(sitting);
        buttonList.add(angry);
        buttonList.add(armor);
        buttonList.add(hasItem);
        buttonList.add(itemIdCycle);
        buttonList.add(metaCycle);
        return buttonList;
    }

    @Override
    public WolfMob getEntityInstance(Minecraft mc, World world) {
        WolfMob wolf = new WolfMob(world);
        wolf.setWolfHeldItem(null);
        return wolf;
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void onClose() {
    }

    static {
        armorMaterials.add(null);
    }
}

