/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.popup.ButtonComponent;
import net.minecraft.client.gui.popup.ButtonGroupComponent;
import net.minecraft.client.gui.popup.GuiPopup;
import net.minecraft.client.gui.popup.LabelComponent;
import net.minecraft.client.gui.popup.ListComponent;
import net.minecraft.client.gui.popup.MessageBoxComponent;
import net.minecraft.client.gui.popup.PopupCloseListener;
import net.minecraft.client.gui.popup.PopupComponent;
import net.minecraft.client.gui.popup.TextInputComponent;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.collection.Pair;

public class PopupBuilder {
    private final GuiScreen parent;
    private final int width;
    private Integer statusCodeOnEsc = null;
    private Integer statusCodeOnEnter = null;
    private Integer statusCodeOnClickOut = null;
    private final List<PopupComponent> components = new ArrayList<PopupComponent>();
    private final Map<PopupComponent, String> componentKeyMap = new HashMap<PopupComponent, String>();
    private final List<PopupCloseListener> onCloseListeners = new ArrayList<PopupCloseListener>();
    private Pair<Integer, Integer> backgroundColor = null;

    public PopupBuilder(GuiScreen parent, int width) {
        this.parent = parent;
        this.width = width;
    }

    public GuiPopup build() {
        GuiPopup popup = new GuiPopup(this.parent, this.width, this.getHeight(), this.statusCodeOnEsc, this.statusCodeOnEnter, this.statusCodeOnClickOut, this.components, this.componentKeyMap, this.onCloseListeners, this.backgroundColor);
        for (PopupComponent component : this.components) {
            component.setParent(popup);
        }
        return popup;
    }

    private int getHeight() {
        int accY = 8;
        for (PopupComponent component : this.components) {
            accY += component.getHeight() + 4;
        }
        accY -= 4;
        return accY += 8;
    }

    public PopupBuilder closeOnEsc(int statusCode) {
        this.statusCodeOnEsc = statusCode;
        return this;
    }

    public PopupBuilder closeOnEnter(int statusCode) {
        this.statusCodeOnEnter = statusCode;
        return this;
    }

    public PopupBuilder closeOnClickOut(int statusCode) {
        this.statusCodeOnClickOut = statusCode;
        return this;
    }

    public PopupBuilder withLabelLiteral(String text, int color) {
        LabelComponent component = new LabelComponent(this.width, text, color);
        this.components.add(component);
        return this;
    }

    public PopupBuilder withLabelLiteral(String text) {
        return this.withLabelLiteral(text, -1);
    }

    public PopupBuilder withLabel(String translationKey, int color) {
        return this.withLabelLiteral(I18n.getInstance().translateKey(translationKey), color);
    }

    public PopupBuilder withLabel(String translationKey) {
        return this.withLabel(translationKey, -1);
    }

    public PopupBuilder withTextField(String key, String defaultText) {
        TextInputComponent component = new TextInputComponent(this.width - 16, defaultText, "");
        this.components.add(component);
        this.componentKeyMap.put(component, key);
        return this;
    }

    public PopupBuilder withTextField(String key, String defaultText, String placeholderTranslationKey) {
        TextInputComponent component = new TextInputComponent(this.width - 16, defaultText, I18n.getInstance().translateKey(placeholderTranslationKey));
        this.components.add(component);
        this.componentKeyMap.put(component, key);
        return this;
    }

    public PopupBuilder withButtonGroup(String key, String[] buttonTranslationKeys, int[] buttonStatusCodes) {
        String[] buttonLabels = new String[buttonTranslationKeys.length];
        for (int i = 0; i < buttonTranslationKeys.length; ++i) {
            buttonLabels[i] = I18n.getInstance().translateKey(buttonTranslationKeys[i]);
        }
        boolean[] enabled = new boolean[buttonTranslationKeys.length];
        Arrays.fill(enabled, true);
        ButtonGroupComponent component = new ButtonGroupComponent(this.width - 16, buttonLabels, buttonStatusCodes, enabled);
        this.components.add(component);
        this.componentKeyMap.put(component, key);
        return this;
    }

    public PopupBuilder withButtonGroup(String key, String[] buttonTranslationKeys, int[] buttonStatusCodes, boolean[] enabled) {
        String[] buttonLabels = new String[buttonTranslationKeys.length];
        for (int i = 0; i < buttonTranslationKeys.length; ++i) {
            buttonLabels[i] = I18n.getInstance().translateKey(buttonTranslationKeys[i]);
        }
        ButtonGroupComponent component = new ButtonGroupComponent(this.width - 16, buttonLabels, buttonStatusCodes, enabled);
        this.components.add(component);
        this.componentKeyMap.put(component, key);
        return this;
    }

    public PopupBuilder withList(String key, int height, String[] buttons, String[] buttonDescs, int selectedItem, boolean closeOnItemSelected) {
        ListComponent component = new ListComponent(this.width - 16, height, buttons, buttonDescs, selectedItem, closeOnItemSelected);
        this.components.add(component);
        this.componentKeyMap.put(component, key);
        return this;
    }

    public PopupBuilder withMessageBox(String key, int height, String text, int chars) {
        MessageBoxComponent component = new MessageBoxComponent(this.width - 16, height, text, chars);
        this.components.add(component);
        this.componentKeyMap.put(component, key);
        return this;
    }

    public PopupBuilder withButton(String key, String labelTranslationKey, int defaultValue, String ... valueTranslationKeys) {
        ButtonComponent component = new ButtonComponent(this.width - 16, labelTranslationKey, valueTranslationKeys, defaultValue);
        this.components.add(component);
        this.componentKeyMap.put(component, key);
        return this;
    }

    public PopupBuilder withBackgroundColor(int color, int color2) {
        this.backgroundColor = Pair.of(color, color2);
        return this;
    }

    public PopupBuilder withOnCloseListener(PopupCloseListener listener) {
        this.onCloseListeners.add(listener);
        return this;
    }
}

