/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.RotatableBlock;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;

public class AxisAlignedBlockModel<T extends Block>
extends StandardBlockModel<T> {
    public AxisAlignedBlockModel(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(AxisAlignedBlockModel.renderBlocks.blockAccess, x, y, z);
        int l = AxisAlignedBlockModel.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        int i1 = RotatableBlock.getOrientation(l);
        switch (i1) {
            case 0: {
                AxisAlignedBlockModel.renderBlocks.uvRotateEast = 0;
                AxisAlignedBlockModel.renderBlocks.uvRotateWest = 0;
                AxisAlignedBlockModel.renderBlocks.uvRotateSouth = 0;
                AxisAlignedBlockModel.renderBlocks.uvRotateNorth = 0;
                break;
            }
            case 1: {
                AxisAlignedBlockModel.renderBlocks.uvRotateSouth = 1;
                AxisAlignedBlockModel.renderBlocks.uvRotateNorth = 1;
                break;
            }
            case 2: {
                AxisAlignedBlockModel.renderBlocks.uvRotateEast = 1;
                AxisAlignedBlockModel.renderBlocks.uvRotateWest = 1;
                AxisAlignedBlockModel.renderBlocks.uvRotateTop = 1;
                AxisAlignedBlockModel.renderBlocks.uvRotateBottom = 1;
            }
        }
        this.renderStandardBlock(tessellator, this.block, x, y, z);
        this.resetRenderBlocks();
        return true;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (6 * (data & 3) + side.getId() >= Sides.orientationLookUpXYZAligned.length) {
            return TextureRegistry.getTexture("minecraft:block/grass_top");
        }
        return this.atlasIndices[Sides.orientationLookUpXYZAligned[6 * (data & 3) + side.getId()]];
    }
}

