/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.FireBlockModel;
import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.BrazierBlock;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class BrazierBlockModel<T extends BrazierBlock>
extends StandardBlockModel<T> {
    protected IconCoordinate sideTexture = TextureRegistry.getTexture("minecraft:block/brazier_side");
    protected IconCoordinate baseTexture = TextureRegistry.getTexture("minecraft:block/brazier_base");
    protected StandardBlockModel<Block> fireModel = new FireBlockModel(Blocks.FIRE, true).withTextures("minecraft:block/fire");

    public BrazierBlockModel(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        tessellator.setColorOpaque_I(0xFFFFFF);
        BrazierBlockModel.renderBlocks.enableAO = true;
        BrazierBlockModel.renderBlocks.cache.setupCache(this.block, BrazierBlockModel.renderBlocks.blockAccess, x, y, z);
        this.renderSide(tessellator, this.block, x, y, z, Side.NORTH, 0);
        this.renderSide(tessellator, this.block, x, y, z, Side.SOUTH, 0);
        this.renderSide(tessellator, this.block, x, y, z, Side.EAST, 0);
        this.renderSide(tessellator, this.block, x, y, z, Side.WEST, 0);
        this.renderSide(tessellator, this.block, x, y, z, Side.BOTTOM, 0);
        double zFightOffset = 0.005;
        ((BrazierBlock)this.block).setBlockBounds(-0.005, -0.005, -0.005, 1.005, 1.005, 1.005);
        this.renderSide(tessellator, this.block, x, y, z + 1, Side.NORTH, 0);
        this.renderSide(tessellator, this.block, x, y, z - 1, Side.SOUTH, 0);
        this.renderSide(tessellator, this.block, x - 1, y, z, Side.EAST, 0);
        this.renderSide(tessellator, this.block, x + 1, y, z, Side.WEST, 0);
        this.renderSide(tessellator, this.block, x, y - 1, z, Side.TOP, 0);
        ((BrazierBlock)this.block).setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        BrazierBlockModel.renderBlocks.enableAO = false;
        if (((BrazierBlock)this.block).isBurning()) {
            this.fireModel.render(tessellator, x, y, z);
        }
        return true;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        this.renderBottomFace(tessellator, this.block, 0.0, 0.0, 0.0, this.baseTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        this.renderTopFace(tessellator, this.block, 0.0, -1.0, 0.0, this.baseTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        this.renderNorthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.sideTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        this.renderNorthFace(tessellator, this.block, 0.0, 0.0, 1.0, this.sideTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        this.renderSouthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.sideTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        this.renderSouthFace(tessellator, this.block, 0.0, 0.0, -1.0, this.sideTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        this.renderWestFace(tessellator, this.block, 0.0, 0.0, 0.0, this.sideTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        this.renderWestFace(tessellator, this.block, 1.0, 0.0, 0.0, this.sideTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        this.renderEastFace(tessellator, this.block, 0.0, 0.0, 0.0, this.sideTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        this.renderEastFace(tessellator, this.block, -1.0, 0.0, 0.0, this.sideTexture);
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side) {
        return true;
    }
}

