/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.blockentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.PistonBlockModel;
import net.minecraft.client.render.block.model.PistonHeadBlockModel;
import net.minecraft.client.render.blockentity.BlockEntityRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.piston.MovingPistonBlockEntity;
import net.minecraft.core.block.piston.PistonHeadBlock;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class PistonBlockEntityRenderer
extends BlockEntityRenderer<MovingPistonBlockEntity> {
    private static final PistonHeadBlockModel blockModelPistonHead = (PistonHeadBlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.PISTON_HEAD);
    private RenderBlocks renderBlocks;
    private final Minecraft mc = Minecraft.getMinecraft(this);

    @Override
    public void onWorldChanged(World world) {
        this.renderBlocks = new RenderBlocks(world);
    }

    @Override
    public void doRender(Tessellator tessellator, MovingPistonBlockEntity tileEntity, double x, double y, double z, float partialTick) {
        Block block = Block.blocksList[tileEntity.getMovedId()];
        if (block != null && tileEntity.getProgress(partialTick) < 1.0f) {
            TextureRegistry.blockAtlas.bind();
            Lighting.disable();
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2884);
            if (this.mc.isAmbientOcclusionEnabled()) {
                GL11.glShadeModel((int)7425);
            } else {
                GL11.glShadeModel((int)7424);
            }
            tessellator.startDrawingQuads();
            tessellator.setTranslation((float)x - (float)tileEntity.x + tileEntity.getXOff(partialTick), (float)y - (float)tileEntity.y + tileEntity.getYOff(partialTick), (float)z - (float)tileEntity.z + tileEntity.getZOff(partialTick));
            tessellator.setColorOpaque(1, 1, 1);
            if (block == Blocks.PISTON_HEAD && tileEntity.getProgress(partialTick) < 0.5f) {
                BlockModel.setRenderBlocks(this.renderBlocks);
                blockModelPistonHead.renderPistonHeadNoCulling(tessellator, (PistonHeadBlock)block, tileEntity.x, tileEntity.y, tileEntity.z, false);
            } else if (tileEntity.isSourcePiston() && !tileEntity.isExtending()) {
                PistonBlockModel pistonBase = (PistonBlockModel)BlockModelDispatcher.getInstance().getDispatch(block);
                BlockModel.setRenderBlocks(this.renderBlocks);
                blockModelPistonHead.setFaceTextureOverride(pistonBase.getFaceTexture());
                blockModelPistonHead.renderPistonHeadNoCulling(tessellator, (PistonHeadBlock)Blocks.PISTON_HEAD, tileEntity.x, tileEntity.y, tileEntity.z, tileEntity.getProgress(partialTick) < 0.5f);
                blockModelPistonHead.setFaceTextureOverride(null);
                tessellator.setTranslation((float)x - (float)tileEntity.x, (float)y - (float)tileEntity.y, (float)z - (float)tileEntity.z);
                pistonBase.renderNoCulling(tessellator, tileEntity.x, tileEntity.y, tileEntity.z);
            } else {
                BlockModel.setRenderBlocks(this.renderBlocks);
                BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(block);
                model.renderNoCulling(tessellator, tileEntity.x, tileEntity.y, tileEntity.z);
            }
            tessellator.setTranslation(0.0, 0.0, 0.0);
            tessellator.draw();
            Lighting.enableLight();
        }
    }
}

