/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.camera;

import net.minecraft.client.render.camera.ICamera;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.FluidBlock;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;

public abstract class CameraUtil {
    public static HitResult traceRay(ICamera camera, World world, double distance, float partialTick) {
        Vec3 pos = camera.getPosition(partialTick);
        Vec3 rot = camera.getRotationVector(partialTick);
        Vec3 endPos = pos.add(rot.x * distance, rot.y * distance, rot.z * distance);
        return world.checkBlockCollisionBetweenPoints(pos, endPos);
    }

    public static boolean isUnderLiquid(ICamera camera, World world, Material material, float partialTick) {
        int z;
        int y;
        double cameraY = camera.getY(partialTick);
        int x = MathHelper.floor(camera.getX(partialTick));
        int id = world.getBlockId(x, y = MathHelper.floor_float(MathHelper.floor(cameraY)), z = MathHelper.floor(camera.getZ(partialTick)));
        if (id != 0 && Block.blocksList[id].blockMaterial == material) {
            float f = FluidBlock.getWaterVolume(world.getBlockMetadata(x, y, z)) - 0.2f;
            float f1 = (float)(y + 1) - f;
            return cameraY < (double)f1;
        }
        return false;
    }
}

