/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.util.helper.MathHelper;

public abstract class DynamicTextureRotating
extends DynamicTexture {
    protected final Minecraft mc;
    protected byte[] dialImageData;
    protected int dialTexRes;
    protected byte[] clockImageData;
    protected double angleFinal;
    protected double delta;

    public DynamicTextureRotating(Minecraft minecraft, IconCoordinate texture) {
        super(texture);
        this.mc = minecraft;
    }

    @Override
    public void postInit() {
        this.initTexture();
        BufferedImage atlas = this.targetTexture.parentAtlas.atlas;
        this.clockImageData = new byte[this.targetTexture.getArea() * 4];
        for (int x = 0; x < this.targetTexture.width; ++x) {
            for (int y = 0; y < this.targetTexture.height; ++y) {
                DynamicTextureRotating.putPixel(this.clockImageData, y * this.targetTexture.width + x, atlas.getRGB(this.targetTexture.iconX + x, this.targetTexture.iconY + y));
            }
        }
    }

    public abstract double getAngle();

    public void updateAngle() {
        double angleSmooth;
        double angle = this.getAngle();
        for (angleSmooth = angle - this.angleFinal; angleSmooth < -3.1415927410125732; angleSmooth += 6.2831854820251465) {
        }
        while (angleSmooth >= 3.1415927410125732) {
            angleSmooth -= 6.2831854820251465;
        }
        if (angleSmooth < -1.0) {
            angleSmooth = -1.0;
        }
        if (angleSmooth > 1.0) {
            angleSmooth = 1.0;
        }
        this.delta += angleSmooth * 0.1;
        this.delta *= 0.8;
        this.angleFinal += this.delta;
    }

    @Override
    public void update() {
        this.updateAngle();
        double x = Math.sin(this.angleFinal);
        double y = Math.cos(this.angleFinal);
        for (int _x = 0; _x < this.targetTexture.width; ++_x) {
            for (int _y = 0; _y < this.targetTexture.height; ++_y) {
                int i = _y * this.targetTexture.width + _x;
                int a = this.clockImageData[i * 4 + 3] & 0xFF;
                int r = this.clockImageData[i * 4 + 0] & 0xFF;
                int g = this.clockImageData[i * 4 + 1] & 0xFF;
                int b = this.clockImageData[i * 4 + 2] & 0xFF;
                if (r == b && g == 0 && b > 0) {
                    double pixelBrightness = (double)r / 256.0;
                    double x2 = -((double)_x / (double)(this.targetTexture.width - 1) - 0.5);
                    double y2 = (double)_y / (double)(this.targetTexture.height - 1) - 0.5;
                    int x3 = (int)((x2 * y + y2 * x + 0.5) * (double)this.dialTexRes);
                    int y3 = (int)((y2 * y - x2 * x + 0.5) * (double)this.dialTexRes);
                    int j = MathHelper.clamp(x3, 0, this.dialTexRes - 1) + MathHelper.clamp(y3, 0, this.dialTexRes - 1) * this.dialTexRes;
                    a = this.dialImageData[j * 4 + 3] & 0xFF;
                    r = this.dialImageData[j * 4 + 0] & 0xFF;
                    g = this.dialImageData[j * 4 + 1] & 0xFF;
                    b = this.dialImageData[j * 4 + 2] & 0xFF;
                    r = (int)((double)r * pixelBrightness);
                    g = (int)((double)g * pixelBrightness);
                    b = (int)((double)b * pixelBrightness);
                }
                this.imageData[i * 4 + 0] = (byte)r;
                this.imageData[i * 4 + 1] = (byte)g;
                this.imageData[i * 4 + 2] = (byte)b;
                this.imageData[i * 4 + 3] = (byte)a;
            }
        }
    }
}

