/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.shader;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiPhotoMode;
import net.minecraft.client.option.enums.Colorblindness;
import net.minecraft.client.render.camera.CameraUtil;
import net.minecraft.client.render.shader.Shader;
import net.minecraft.core.block.material.Material;
import org.lwjgl.opengl.GL11;

public abstract class Shaders {
    private static int fullscreenRectList;
    public static boolean enableShaders;
    private static final long startTime;
    private static float frameTimeCounter;

    public static void drawFullscreenRect() {
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3089);
        GL11.glDisable((int)3008);
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        GL11.glEnable((int)3553);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5889);
        if (fullscreenRectList == 0) {
            fullscreenRectList = GL11.glGenLists((int)1);
            GL11.glNewList((int)fullscreenRectList, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2d((double)0.0, (double)0.0);
            GL11.glVertex2d((double)-1.0, (double)-1.0);
            GL11.glTexCoord2d((double)0.0, (double)1.0);
            GL11.glVertex2d((double)-1.0, (double)1.0);
            GL11.glTexCoord2d((double)1.0, (double)1.0);
            GL11.glVertex2d((double)1.0, (double)1.0);
            GL11.glTexCoord2d((double)1.0, (double)0.0);
            GL11.glVertex2d((double)1.0, (double)-1.0);
            GL11.glEnd();
            GL11.glEndList();
        }
        GL11.glCallList((int)fullscreenRectList);
    }

    public static void setUniforms(Minecraft minecraft, Shader shader, float partialTicks) {
        long now = System.currentTimeMillis();
        int passedTime = (int)(now - startTime);
        frameTimeCounter = (float)passedTime / 1000.0f;
        if (!shader.isEnabled()) {
            return;
        }
        shader.bind();
        shader.uniformFloat("width", minecraft.resolution.width);
        shader.uniformFloat("height", minecraft.resolution.height);
        shader.uniformFloat("frameTimeCounter", frameTimeCounter);
        shader.uniformFloat("gamma", ((Float)minecraft.gameSettings.gamma.value).floatValue());
        shader.uniformFloat("fxaa", ((Float)minecraft.gameSettings.fxaa.value).floatValue());
        shader.uniformFloat("heatHaze", (Boolean)minecraft.gameSettings.heatHaze.value != false ? minecraft.ppm.heatHaze : 0.0f);
        shader.uniformInt("bloom", (Integer)minecraft.gameSettings.bloom.value);
        shader.uniformInt("dimension", minecraft.theWorld != null && minecraft.theWorld.dimension != null ? minecraft.theWorld.dimension.id : 0);
        shader.uniformInt("cbCorrectionMode", ((Colorblindness)((Object)minecraft.gameSettings.colorblindnessFix.value)).ordinal());
        int isEyeInLiquid = 0;
        float celestialAngle = 0.0f;
        if (minecraft.thePlayer != null && minecraft.theWorld != null && minecraft.activeCamera != null) {
            if (CameraUtil.isUnderLiquid(minecraft.activeCamera, minecraft.theWorld, Material.lava, partialTicks)) {
                isEyeInLiquid = 2;
            } else if (CameraUtil.isUnderLiquid(minecraft.activeCamera, minecraft.theWorld, Material.water, partialTicks)) {
                isEyeInLiquid = 1;
            }
            celestialAngle = minecraft.theWorld.getCelestialAngle(partialTicks);
        }
        shader.uniformInt("isEyeInLiquid", isEyeInLiquid);
        shader.uniformFloat("celestialAngle", celestialAngle);
        if (minecraft.ppm.enabled) {
            shader.uniformFloat("brightness", minecraft.ppm.brightness);
            shader.uniformFloat("contrast", minecraft.ppm.contrast);
            shader.uniformFloat("exposure", minecraft.ppm.exposure);
            shader.uniformFloat("saturation", minecraft.ppm.saturation);
            shader.uniformFloat("rMod", minecraft.ppm.rMod);
            shader.uniformFloat("gMod", minecraft.ppm.gMod);
            shader.uniformFloat("bMod", minecraft.ppm.bMod);
        } else {
            shader.uniformFloat("brightness", 0.0f);
            shader.uniformFloat("contrast", 0.0f);
            shader.uniformFloat("exposure", 0.0f);
            shader.uniformFloat("saturation", 0.0f);
            shader.uniformFloat("rMod", 1.0f);
            shader.uniformFloat("gMod", 1.0f);
            shader.uniformFloat("bMod", 1.0f);
        }
        shader.uniformFloat("photoMode", minecraft.currentScreen instanceof GuiPhotoMode);
        shader.uniformFloat("guiOpened", minecraft.currentScreen != null);
        if (minecraft.currentScreen instanceof GuiPhotoMode) {
            GuiPhotoMode guiPhotoMode = (GuiPhotoMode)minecraft.currentScreen;
            shader.uniformFloat("intensity", guiPhotoMode.intensityValue);
        } else {
            shader.uniformFloat("intensity", 1.0f);
        }
    }

    static {
        enableShaders = false;
        startTime = System.currentTimeMillis();
        frameTimeCounter = 0.0f;
    }
}

