/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texture.stitcher;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import net.minecraft.client.render.texture.meta.TextureMetaHandler;
import net.minecraft.client.render.texture.stitcher.AtlasStitcher;
import net.minecraft.core.util.collection.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconCoordinate
implements Comparable<IconCoordinate> {
    public int iconX;
    public int iconY;
    public int width;
    public int height;
    private boolean pendingDimensions;
    protected final String sourceImage;
    protected final TextureMetaHandler metaHandler = new TextureMetaHandler();
    public final NamespaceID namespaceId;
    public final AtlasStitcher parentAtlas;
    private BufferedImage _imageStorage;

    public IconCoordinate(AtlasStitcher stitcher, NamespaceID namespaceId, String sourceImage) {
        this.parentAtlas = stitcher;
        this.namespaceId = namespaceId;
        this.sourceImage = sourceImage;
    }

    protected void setImage(BufferedImage image) {
        this.pendingDimensions = true;
        this._imageStorage = image;
    }

    public BufferedImage getImageStorage() {
        return this._imageStorage;
    }

    protected void discardImage() {
        this._imageStorage = null;
    }

    public boolean needsDimensions() {
        return this.pendingDimensions;
    }

    public void setDimension(int width, int height) {
        this.width = width;
        this.height = height;
        this.pendingDimensions = false;
    }

    public void setPosition(int x, int y) {
        this.iconX = x;
        this.iconY = y;
    }

    public int getArea() {
        return this.width * this.height;
    }

    protected void drawToAtlas(Graphics2D atlas) {
        if (this.width != this._imageStorage.getWidth() || this.height != this._imageStorage.getHeight()) {
            int[] subImage = this._imageStorage.getRGB(0, 0, this.width, this.height, null, 0, this.width);
            BufferedImage _img = new BufferedImage(this.width, this.height, 2);
            _img.setRGB(0, 0, this.width, this.height, subImage, 0, this.width);
            atlas.drawImage((Image)_img, this.iconX, this.iconY, null);
            return;
        }
        atlas.drawImage((Image)this._imageStorage, this.iconX, this.iconY, null);
    }

    public double getIconUMin() {
        return (double)this.iconX * this.parentAtlas.getInverseWidth();
    }

    public double getIconUMax() {
        return ((double)this.iconX + (double)this.width) * this.parentAtlas.getInverseWidth();
    }

    public double getIconVMin() {
        return (double)this.iconY * this.parentAtlas.getInverseHeight();
    }

    public double getIconVMax() {
        return ((double)this.iconY + (double)this.height) * this.parentAtlas.getInverseHeight();
    }

    public double getSubIconU(double offset) {
        return ((double)this.iconX + offset * (double)this.width) * this.parentAtlas.getInverseWidth();
    }

    public double getSubIconV(double offset) {
        return ((double)this.iconY + offset * (double)this.height) * this.parentAtlas.getInverseHeight();
    }

    public String toString() {
        return String.format("W:%d, H:%d, X:%d, Y:%d | ID:%s, Source:%s", this.width, this.height, this.iconX, this.iconY, this.namespaceId, this.sourceImage);
    }

    public String getImageSource() {
        return this.sourceImage;
    }

    @Override
    public int compareTo(@NotNull IconCoordinate o) {
        int res = o.height - this.height;
        if (res != 0) {
            return res;
        }
        return this.namespaceId.compareTo(o.namespaceId);
    }

    protected void resetMetadata() {
        this.metaHandler.reset();
    }

    protected void initMetadata(InputStream stream) {
        this.metaHandler.loadFromStream(stream);
    }

    public boolean hasMeta(String key) {
        return this.metaHandler.has(key);
    }

    @Nullable
    public <T> T getMeta(String key, Class<T> aClass) {
        return this.metaHandler.get(key, aClass);
    }

    public <T> T getOrDefaultMeta(String key, T metaDefault, Class<T> aClass) {
        return this.metaHandler.getOrDefault(key, metaDefault, aClass);
    }
}

