/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world.chunk.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkCoordinate;
import net.minecraft.core.world.chunk.EmptyChunk;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;

public class ChunkProviderDynamic
implements IChunkProvider {
    private final Set<Integer> droppedChunksSet = new HashSet<Integer>();
    private final Chunk emptyChunk;
    public ChunkGenerator chunkGenerator;
    private final IChunkLoader chunkLoader;
    private final Map<Integer, Chunk> chunkMap = new HashMap<Integer, Chunk>();
    private final Map<Integer, Chunk> forceLoadedChunkMap;
    private final List<Chunk> forceLoadedChunkList = new ArrayList<Chunk>();
    private final World world;
    private int currentChunkX;
    private int currentChunkZ;
    public int forceLoadedChunksLimit = 64;
    public int maxUnloadPerTick = 10;
    private int lastQueriedChunkXPos;
    private int lastQueriedChunkZPos;
    private Chunk lastQueriedChunk;

    public ChunkProviderDynamic(World world, IChunkLoader chunkLoader, ChunkGenerator chunkGenerator) {
        this.forceLoadedChunkMap = new HashMap<Integer, Chunk>();
        this.emptyChunk = new EmptyChunk(world, 0, 0);
        this.world = world;
        this.chunkLoader = chunkLoader;
        this.chunkGenerator = chunkGenerator;
    }

    @Override
    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        int id = ChunkCoordinate.toInt(chunkX, chunkZ);
        if (this.canChunkBeUnloaded(chunkX, chunkZ)) {
            if (this.chunkMap.containsKey(id)) {
                this.droppedChunksSet.add(id);
            }
            return false;
        }
        Chunk chunk = this.chunkMap.get(id);
        return chunk == this.emptyChunk || chunk != null && chunk.isAtLocation(chunkX, chunkZ);
    }

    public boolean canChunkBeUnloaded(int chunkX, int chunkZ) {
        int id = ChunkCoordinate.toInt(chunkX, chunkZ);
        if (this.forceLoadedChunkMap.containsKey(id)) {
            return false;
        }
        int renderDistance = (Integer)Minecraft.getMinecraft((Object)this).gameSettings.renderDistance.value;
        return chunkX <= this.currentChunkX - renderDistance || chunkZ <= this.currentChunkZ - renderDistance || chunkX >= this.currentChunkX + renderDistance || chunkZ >= this.currentChunkZ + renderDistance;
    }

    @Override
    public Chunk provideChunk(int chunkX, int chunkZ) {
        if (chunkX == this.lastQueriedChunkXPos && chunkZ == this.lastQueriedChunkZPos && this.lastQueriedChunk != null) {
            return this.lastQueriedChunk;
        }
        if (!this.world.findingSpawnPoint && this.canChunkBeUnloaded(chunkX, chunkZ)) {
            return this.emptyChunk;
        }
        int id = ChunkCoordinate.toInt(chunkX, chunkZ);
        if (!this.isChunkLoaded(chunkX, chunkZ)) {
            Chunk chunk;
            if (this.chunkMap.get(id) != null) {
                chunk = this.chunkMap.get(id);
                this.saveChunk(chunk);
                chunk.onUnload();
            }
            if ((chunk = this.loadChunk(chunkX, chunkZ)) == null) {
                if (this.chunkGenerator != null) {
                    chunk = this.chunkGenerator.generate(chunkX, chunkZ);
                    chunk.fixMissingBlocks();
                } else {
                    chunk = this.emptyChunk;
                }
            }
            this.chunkMap.put(id, chunk);
            chunk.onLoad();
            if (chunk.isTerrainPopulated && this.isChunkLoaded(chunkX + 1, chunkZ + 1) && this.isChunkLoaded(chunkX, chunkZ + 1) && this.isChunkLoaded(chunkX + 1, chunkZ)) {
                this.populate(this, chunkX, chunkZ);
            }
            if (this.isChunkLoaded(chunkX - 1, chunkZ) && !this.provideChunk((int)(chunkX - 1), (int)chunkZ).isTerrainPopulated && this.isChunkLoaded(chunkX - 1, chunkZ + 1) && this.isChunkLoaded(chunkX, chunkZ + 1) && this.isChunkLoaded(chunkX - 1, chunkZ)) {
                this.populate(this, chunkX - 1, chunkZ);
            }
            if (this.isChunkLoaded(chunkX, chunkZ - 1) && !this.provideChunk((int)chunkX, (int)(chunkZ - 1)).isTerrainPopulated && this.isChunkLoaded(chunkX + 1, chunkZ - 1) && this.isChunkLoaded(chunkX, chunkZ - 1) && this.isChunkLoaded(chunkX + 1, chunkZ)) {
                this.populate(this, chunkX, chunkZ - 1);
            }
            if (this.isChunkLoaded(chunkX - 1, chunkZ - 1) && !this.provideChunk((int)(chunkX - 1), (int)(chunkZ - 1)).isTerrainPopulated && this.isChunkLoaded(chunkX - 1, chunkZ - 1) && this.isChunkLoaded(chunkX, chunkZ - 1) && this.isChunkLoaded(chunkX - 1, chunkZ)) {
                this.populate(this, chunkX - 1, chunkZ - 1);
            }
            if (this.world.getCurrentWeather() != null) {
                this.world.getCurrentWeather().doChunkLoadEffect(this.world, chunk);
            }
        }
        this.lastQueriedChunkXPos = chunkX;
        this.lastQueriedChunkZPos = chunkZ;
        this.lastQueriedChunk = this.chunkMap.get(id);
        return this.chunkMap.get(id);
    }

    @Override
    public Chunk prepareChunk(int chunkX, int chunkZ) {
        return this.provideChunk(chunkX, chunkZ);
    }

    @Override
    public void regenerateChunk(int chunkX, int chunkZ) {
        int id = ChunkCoordinate.toInt(chunkX, chunkZ);
        this.droppedChunksSet.remove(id);
        this.chunkMap.remove(id);
        if (this.chunkGenerator == null) {
            return;
        }
        Chunk chunk = this.chunkGenerator.generate(chunkX, chunkZ);
        chunk.fixMissingBlocks();
        this.chunkMap.put(id, chunk);
        if (!chunk.isTerrainPopulated && this.isChunkLoaded(chunkX + 1, chunkZ + 1) && this.isChunkLoaded(chunkX, chunkZ + 1) && this.isChunkLoaded(chunkX + 1, chunkZ)) {
            this.populate(this, chunkX, chunkZ);
        }
        if (this.isChunkLoaded(chunkX - 1, chunkZ) && !this.provideChunk((int)(chunkX - 1), (int)chunkZ).isTerrainPopulated && this.isChunkLoaded(chunkX - 1, chunkZ + 1) && this.isChunkLoaded(chunkX, chunkZ + 1) && this.isChunkLoaded(chunkX - 1, chunkZ)) {
            this.populate(this, chunkX - 1, chunkZ);
        }
        if (this.isChunkLoaded(chunkX, chunkZ - 1) && !this.provideChunk((int)chunkX, (int)(chunkZ - 1)).isTerrainPopulated && this.isChunkLoaded(chunkX + 1, chunkZ - 1) && this.isChunkLoaded(chunkX, chunkZ - 1) && this.isChunkLoaded(chunkX + 1, chunkZ)) {
            this.populate(this, chunkX, chunkZ - 1);
        }
        if (this.isChunkLoaded(chunkX - 1, chunkZ - 1) && !this.provideChunk((int)(chunkX - 1), (int)(chunkZ - 1)).isTerrainPopulated && this.isChunkLoaded(chunkX - 1, chunkZ - 1) && this.isChunkLoaded(chunkX, chunkZ - 1) && this.isChunkLoaded(chunkX - 1, chunkZ)) {
            this.populate(this, chunkX - 1, chunkZ - 1);
        }
    }

    @Override
    public void populate(IChunkProvider chunkProvider, int chunkX, int chunkZ) {
        Chunk chunk = this.provideChunk(chunkX, chunkZ);
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            if (this.chunkGenerator != null) {
                this.chunkGenerator.decorate(chunk);
                chunk.setChunkModified();
            }
        }
    }

    public boolean keepLoaded(int chunkX, int chunkZ) {
        int id = ChunkCoordinate.toInt(chunkX, chunkZ);
        Chunk chunk = this.chunkMap.get(id);
        if (!this.forceLoadedChunkMap.containsKey(id) && this.forceLoadedChunkList.size() < this.forceLoadedChunksLimit) {
            this.forceLoadedChunkMap.put(id, chunk);
            this.forceLoadedChunkList.add(chunk);
            return true;
        }
        return false;
    }

    public boolean removeFromForceLoaded(int chunkX, int chunkZ) {
        int id = ChunkCoordinate.toInt(chunkX, chunkZ);
        this.forceLoadedChunkList.remove(this.forceLoadedChunkMap.get(id));
        return this.forceLoadedChunkMap.remove(id) != null;
    }

    @Override
    public boolean saveChunks(boolean saveImmediately, ProgressListener progressUpdate) {
        int attempts = 0;
        int chunksToBeSaved = 0;
        if (progressUpdate != null) {
            for (Chunk chunk : this.chunkMap.values()) {
                if (chunk == null || !chunk.needsSaving(saveImmediately)) continue;
                ++chunksToBeSaved;
            }
        }
        int progress = 0;
        for (Chunk chunk : this.chunkMap.values()) {
            if (chunk == null || !chunk.needsSaving(saveImmediately)) continue;
            this.saveChunk(chunk);
            chunk.isModified = false;
            if (++attempts == 2 && !saveImmediately) {
                return false;
            }
            if (progressUpdate == null || ++progress % 10 != 0) continue;
            progressUpdate.progressStagePercentage(progress * 100 / chunksToBeSaved);
        }
        return true;
    }

    private void saveChunk(Chunk chunk) {
        if (this.chunkLoader == null) {
            return;
        }
        try {
            chunk.lastSaveTime = this.world.getWorldTime();
            this.chunkLoader.saveChunk(this.world, chunk);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    private Chunk loadChunk(int i, int j) {
        if (this.chunkLoader == null) {
            return this.emptyChunk;
        }
        try {
            Chunk chunk = this.chunkLoader.loadChunk(this.world, i, j);
            if (chunk != null) {
                chunk.lastSaveTime = this.world.getWorldTime();
            }
            return chunk;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.emptyChunk;
        }
    }

    @Override
    public boolean tick() {
        int dropped = 0;
        for (Chunk chunk : this.chunkMap.values()) {
            if (dropped < this.maxUnloadPerTick && this.isChunkLoaded(chunk.xPosition, chunk.zPosition)) continue;
            break;
        }
        if (!this.droppedChunksSet.isEmpty()) {
            int unloaded = 0;
            HashSet<Integer> copy = new HashSet<Integer>(this.droppedChunksSet);
            for (int i : copy) {
                if (unloaded >= this.maxUnloadPerTick) break;
                if (this.forceLoadedChunkMap.containsKey(i)) continue;
                if (this.chunkMap.containsKey(i)) {
                    Chunk chunk = this.chunkMap.get(i);
                    chunk.onUnload();
                    this.saveChunk(chunk);
                    this.chunkMap.remove(i);
                    this.droppedChunksSet.remove(i);
                    ++unloaded;
                    continue;
                }
                this.droppedChunksSet.remove(i);
            }
        }
        return false;
    }

    @Override
    public boolean canSave() {
        return true;
    }

    public IChunkLoader getChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public String getInfoString() {
        return "Chunks: " + this.chunkMap.size() + ", Dropped: " + this.droppedChunksSet.size() + ", Chunkloaded: " + this.forceLoadedChunkMap.size() + "/" + this.forceLoadedChunksLimit;
    }

    public List<Chunk> getForceLoadedChunks() {
        return Collections.unmodifiableList(this.forceLoadedChunkList);
    }

    @Override
    public void unloadAllChunks() {
        for (Chunk chunk : this.chunkMap.values()) {
            if (chunk == null) continue;
            chunk.onUnload();
        }
        this.chunkMap.clear();
        this.droppedChunksSet.clear();
        this.forceLoadedChunkMap.clear();
        this.forceLoadedChunkList.clear();
        this.chunkGenerator = null;
        System.gc();
    }

    @Override
    public void setCurrentChunkOver(int chunkX, int chunkZ) {
        this.currentChunkX = chunkX;
        this.currentChunkZ = chunkZ;
    }
}

