/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class FlowerBlock
extends Block
implements IBonemealable {
    public boolean killedByWeather = false;
    public boolean canBeBonemealed = false;

    public FlowerBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.plant);
        this.setTicking(true);
        float f = 0.2f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, f * 3.0f, 0.5f + f);
    }

    public FlowerBlock setKilledByWeather() {
        this.killedByWeather = true;
        return this;
    }

    public FlowerBlock setBonemealable() {
        this.canBeBonemealed = true;
        return this;
    }

    @Override
    public int getPlacedBlockMetadata(Player player, ItemStack stack, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        return 128;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return super.canPlaceBlockAt(world, x, y, z) && this.canThisPlantGrowOnThisBlockID(world.getBlockId(x, y - 1, z));
    }

    protected boolean canThisPlantGrowOnThisBlockID(int i) {
        if (Block.blocksList[i] == null) {
            return false;
        }
        return Block.blocksList[i].hasTag(BlockTags.GROWS_FLOWERS);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        super.onNeighborBlockChange(world, x, y, z, blockId);
        this.func_268_h(world, x, y, z);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        this.func_268_h(world, x, y, z);
        if (world.getSeasonManager().getCurrentSeason() != null && (world.getBlockMetadata(x, y, z) & 0x40) == 0 && world.getSeasonManager().getCurrentSeason().killFlowers && this.killedByWeather && rand.nextInt(256) == 0) {
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    protected final void func_268_h(World world, int i, int j, int k) {
        if (!this.canBlockStay(world, i, j, k)) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, i, j, k, world.getBlockMetadata(i, j, k), null);
            world.setBlockWithNotify(i, j, k, 0);
        }
    }

    @Override
    public boolean canBlockStay(World world, int x, int y, int z) {
        return (world.getFullBlockLightValue(x, y, z) >= 8 || world.canBlockSeeTheSky(x, y, z)) && this.canThisPlantGrowOnThisBlockID(world.getBlockId(x, y - 1, z));
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean onBonemealUsed(ItemStack itemstack, Player entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        Random rand = world.rand;
        if (!world.isClientSide && this.canBeBonemealed) {
            if (entityplayer.getGamemode().consumeBlocks()) {
                --itemstack.stackSize;
            }
            block0: for (int j1 = 0; j1 < 128; ++j1) {
                int k1 = blockX;
                int l1 = blockY;
                int i2 = blockZ;
                for (int j2 = 0; j2 < j1 / 16; ++j2) {
                    int id1 = world.getBlockId(k1 += rand.nextInt(3) - 1, (l1 += (rand.nextInt(3) - 1) * rand.nextInt(3) / 2) - 1, i2 += rand.nextInt(3) - 1);
                    if (Block.blocksList[id1] == null || !Block.blocksList[id1].hasTag(BlockTags.GROWS_FLOWERS)) continue block0;
                }
                if (world.getBlockId(k1, l1, i2) != 0 || !((double)rand.nextFloat() > 0.75)) continue;
                world.setBlockWithNotify(k1, l1, i2, this.id);
            }
            return true;
        }
        return this.canBeBonemealed;
    }
}

