/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class RedstoneBlock
extends Block {
    public RedstoneBlock(String key, String namespaceId, int id, Material material) {
        super(key, namespaceId, id, material);
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public boolean getSignal(WorldSource blockAccess, int x, int y, int z, Side side) {
        return true;
    }

    @Override
    public boolean getDirectSignal(World world, int x, int y, int z, Side side) {
        return this.getSignal(world, x, y, z, side);
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        for (Side s : Side.sides) {
            world.notifyBlocksOfNeighborChange(x + s.getOffsetX(), y + s.getOffsetY(), z + s.getOffsetZ(), this.id);
        }
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        for (Side s : Side.sides) {
            world.notifyBlocksOfNeighborChange(x + s.getOffsetX(), y + s.getOffsetY(), z + s.getOffsetZ(), this.id);
        }
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        this.spawnParticles(world, x, y, z);
    }

    private void spawnParticles(World world, int x, int y, int z) {
        Random random = world.rand;
        int redstoneBrightness = 10;
        Color color = Colors.allRedstoneColors[10];
        if (color == null) {
            return;
        }
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        double d = 0.0625;
        for (Side s : Side.sides) {
            double px = (double)x + (double)random.nextFloat();
            double py = (double)y + (double)random.nextFloat();
            double pz = (double)z + (double)random.nextFloat();
            switch (s) {
                case BOTTOM: {
                    if (world.isBlockOpaqueCube(x, y + 1, z)) break;
                    py = (double)(y + 1) + 0.0625;
                    break;
                }
                case TOP: {
                    if (world.isBlockOpaqueCube(x, y - 1, z)) break;
                    py = (double)(y + 0) - 0.0625;
                    break;
                }
                case NORTH: {
                    if (world.isBlockOpaqueCube(x, y, z + 1)) break;
                    pz = (double)(z + 1) + 0.0625;
                    break;
                }
                case SOUTH: {
                    if (world.isBlockOpaqueCube(x, y, z - 1)) break;
                    pz = (double)(z + 0) - 0.0625;
                    break;
                }
                case WEST: {
                    if (world.isBlockOpaqueCube(x + 1, y, z)) break;
                    px = (double)(x + 1) + 0.0625;
                    break;
                }
                case EAST: {
                    if (world.isBlockOpaqueCube(x - 1, y, z)) break;
                    px = (double)(x + 0) - 0.0625;
                }
            }
            if (!(px < (double)x || px > (double)(x + 1) || py < 0.0 || py > (double)(y + 1) || pz < (double)z) && !(pz > (double)(z + 1))) continue;
            world.spawnParticle("reddust", px, py, pz, red, green, blue, 10);
        }
    }
}

