/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.FlowerBlock;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public abstract class SaplingBaseBlock
extends FlowerBlock
implements IBonemealable {
    public boolean canGrowOnSand = false;

    public SaplingBaseBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id);
        float f = 0.4f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
    }

    @Override
    public boolean canThisPlantGrowOnThisBlockID(int i) {
        return i == Blocks.SAND.id || super.canThisPlantGrowOnThisBlockID(i);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isClientSide) {
            return;
        }
        if (!this.canGrowOnSand && world.getBlockId(x, y - 1, z) == Blocks.SAND.id) {
            world.setBlockWithNotify(x, y, z, Blocks.DEADBUSH.id);
        }
        super.updateTick(world, x, y, z, rand);
        int growthRate = 30;
        if (world.getSeasonManager().getCurrentSeason() != null) {
            growthRate = MathHelper.floor_float((float)growthRate / world.getSeasonManager().getCurrentSeason().cropGrowthFactor);
        }
        if (world.getBlockLightValue(x, y + 1, z) >= 9 && rand.nextInt(growthRate) == 0) {
            int l = world.getBlockMetadata(x, y, z);
            if ((l & 8) == 0) {
                world.setBlockMetadataWithNotify(x, y, z, l | 8);
            } else {
                this.growTree(world, x, y, z, rand);
            }
        }
    }

    @Override
    public boolean onBonemealUsed(ItemStack itemstack, Player entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (!world.isClientSide) {
            ((SaplingBaseBlock)Block.blocksList[this.id]).growTree(world, blockX, blockY, blockZ, world.rand);
            if (entityplayer.getGamemode().consumeBlocks()) {
                --itemstack.stackSize;
            }
        }
        return true;
    }

    public abstract void growTree(World var1, int var2, int var3, int var4, Random var5);
}

