/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.Global;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.RotatableEntityBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.TrommelBlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.ItemEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class TrommelBlock
extends RotatableEntityBlock {
    private boolean isActive;
    protected static boolean keepTrommelInventory = false;
    private Random random;

    public TrommelBlock(String key, String namespaceId, int id, Material material, boolean isActive) {
        super(key, namespaceId, id, material);
        this.isActive = isActive;
        this.random = new Random();
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        super.onBlockPlacedByWorld(world, x, y, z);
        this.setDefaultDirection(world, x, y, z);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        switch (dropCause) {
            case PICK_BLOCK: 
            case EXPLOSION: 
            case PROPER_TOOL: 
            case SILK_TOUCH: {
                return new ItemStack[]{new ItemStack(Blocks.TROMMEL_IDLE)};
            }
        }
        return null;
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (!world.isClientSide) {
            TrommelBlockEntity tileEntityTrommel = (TrommelBlockEntity)world.getBlockEntity(x, y, z);
            player.displayGUITrommel(tileEntityTrommel);
        }
        return true;
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        if (!this.isActive) {
            return;
        }
        double xPos = (double)x + (double)rand.nextFloat();
        double yPos = (double)y + (double)rand.nextFloat() * 0.5 + 1.0;
        double zPos = (double)z + (double)rand.nextFloat();
        world.spawnParticle("smoke", xPos, yPos, zPos, 0.0, 0.0, 0.0, 0);
    }

    public static void updateTrommelBlockState(boolean flag, World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        BlockEntity tileentity = world.getBlockEntity(i, j, k);
        if (tileentity == null) {
            String msg = "Trommel is missing Tile Entity at x: " + i + " y: " + j + " z: " + k + ", block will be removed!";
            if (Global.BUILD_CHANNEL.isUnstableBuild()) {
                throw new RuntimeException(msg);
            }
            world.setBlockWithNotify(i, j, k, 0);
            System.out.println(msg);
            return;
        }
        keepTrommelInventory = true;
        if (flag) {
            world.setBlockWithNotify(i, j, k, Blocks.TROMMEL_ACTIVE.id);
        } else {
            world.setBlockWithNotify(i, j, k, Blocks.TROMMEL_IDLE.id);
        }
        keepTrommelInventory = false;
        world.setBlockMetadataWithNotify(i, j, k, l);
        tileentity.validate();
        world.setBlockTileEntity(i, j, k, tileentity);
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        if (!keepTrommelInventory && world.getBlockEntity(x, y, z) != null) {
            TrommelBlockEntity tileentitytrommel = (TrommelBlockEntity)world.getBlockEntity(x, y, z);
            for (int l = 0; l < tileentitytrommel.getContainerSize(); ++l) {
                ItemStack itemstack = tileentitytrommel.getItem(l);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = this.random.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    ItemEntity entityitem = new ItemEntity(world, (float)x + f, (float)y + f1, (float)z + f2, new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                    float f3 = 0.05f;
                    entityitem.xd = (float)this.random.nextGaussian() * f3;
                    entityitem.yd = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.zd = (float)this.random.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
        }
        super.onBlockRemoved(world, x, y, z, data);
    }

    @Override
    protected BlockEntity getNewBlockEntity() {
        return new TrommelBlockEntity();
    }
}

