/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.gamerule.GameRule;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.data.registry.Registry;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeRegistry;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryBlastFurnace;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingShaped;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingShapeless;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingWithTool;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryFurnace;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryLabel;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryLabelDye;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryMapDuplication;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryRepairable;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryRepairableStackable;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryScrap;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryTrommel;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypes;

public class Registries
extends Registry<Registry<?>> {
    public static final Registry<WorldType> WORLD_TYPES = new Registry();
    public static final Registry<Biome> BIOMES = new Registry();
    public static final Registry<GameRule<?>> GAME_RULES = new Registry();
    public static final Registry<Class<? extends RecipeEntryBase<?, ?, ?>>> RECIPE_TYPES = new Registry();
    public static final Registry<List<ItemStack>> ITEM_GROUPS = new Registry();
    public static RecipeRegistry RECIPES;
    public static RecipeRegistry RECIPES_LOCAL_COPY;
    private static Registries INSTANCE;
    public static boolean init;

    public Registries() {
        if (init) {
            return;
        }
        init = true;
        INSTANCE = this;
        this.register("minecraft:world_types", WORLD_TYPES);
        this.register("minecraft:biomes", BIOMES);
        this.register("minecraft:recipe_types", RECIPE_TYPES);
        this.register("minecraft:item_groups", ITEM_GROUPS);
        this.init();
        this.register("minecraft:recipes", RECIPES);
    }

    private void init() {
        WorldTypes.init();
        Biomes.init();
        GameRules.init();
        RECIPE_TYPES.register("minecraft:crafting/shaped", RecipeEntryCraftingShaped.class);
        RECIPE_TYPES.register("minecraft:crafting/shapeless", RecipeEntryCraftingShapeless.class);
        RECIPE_TYPES.register("minecraft:crafting/label", RecipeEntryLabel.class);
        RECIPE_TYPES.register("minecraft:crafting/label_dye", RecipeEntryLabelDye.class);
        RECIPE_TYPES.register("minecraft:crafting/scrap", RecipeEntryScrap.class);
        RECIPE_TYPES.register("minecraft:crafting/repairable", RecipeEntryRepairable.class);
        RECIPE_TYPES.register("minecraft:crafting/repairable_stackable", RecipeEntryRepairableStackable.class);
        RECIPE_TYPES.register("minecraft:crafting/uses_tool", RecipeEntryCraftingWithTool.class);
        RECIPE_TYPES.register("minecraft:crafting/map_duplication", RecipeEntryMapDuplication.class);
        RECIPE_TYPES.register("minecraft:smelting", RecipeEntryFurnace.class);
        RECIPE_TYPES.register("minecraft:smelting/blast", RecipeEntryBlastFurnace.class);
        RECIPE_TYPES.register("minecraft:trommeling", RecipeEntryTrommel.class);
        ITEM_GROUPS.register("minecraft:stones", Registries.stackListOf(Blocks.STONE, Blocks.BASALT, Blocks.LIMESTONE, Blocks.GRANITE));
        ITEM_GROUPS.register("minecraft:cobblestones", Registries.stackListOf(Blocks.COBBLE_STONE, Blocks.COBBLE_BASALT, Blocks.COBBLE_LIMESTONE, Blocks.COBBLE_GRANITE, Blocks.COBBLE_PERMAFROST));
        ITEM_GROUPS.register("minecraft:planks", Registries.stackListOf(Blocks.PLANKS_OAK, new ItemStack(Blocks.PLANKS_OAK_PAINTED, 1, 0), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 1, 1), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 1, 2), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 1, 3), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 1, 4), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 1, 5), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 1, 6), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 1, 7), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 1, 8), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 1, 9), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 1, 10), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 1, 11), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 1, 12), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 1, 13), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 1, 14), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 1, 15)));
        ITEM_GROUPS.register("minecraft:grasses", Registries.stackListOf(Blocks.GRASS, Blocks.GRASS_RETRO));
        ITEM_GROUPS.register("minecraft:dirt", Registries.stackListOf(Blocks.DIRT, Blocks.DIRT_SCORCHED));
        ITEM_GROUPS.register("minecraft:trommel_dirt", Registries.stackListOf(Blocks.DIRT, Blocks.DIRT_SCORCHED, Blocks.GRASS, Blocks.GRASS_RETRO, Blocks.GRASS_SCORCHED, Blocks.PATH_DIRT, Blocks.FARMLAND_DIRT));
        ITEM_GROUPS.register("minecraft:moss_stones", Registries.stackListOf(Blocks.MOSS_STONE, Blocks.MOSS_BASALT, Blocks.MOSS_LIMESTONE, Blocks.MOSS_GRANITE));
        ITEM_GROUPS.register("minecraft:logs", Registries.stackListOf(Blocks.LOG_OAK, Blocks.LOG_PINE, Blocks.LOG_BIRCH, Blocks.LOG_CHERRY, Blocks.LOG_EUCALYPTUS, Blocks.LOG_OAK_MOSSY, Blocks.LOG_THORN, Blocks.LOG_PALM));
        ITEM_GROUPS.register("minecraft:leaves", Registries.stackListOf(Blocks.LEAVES_OAK, Blocks.LEAVES_OAK_RETRO, Blocks.LEAVES_PINE, Blocks.LEAVES_BIRCH, Blocks.LEAVES_CHERRY, Blocks.LEAVES_EUCALYPTUS, Blocks.LEAVES_SHRUB));
        ITEM_GROUPS.register("minecraft:coal_ores", Registries.stackListOf(Blocks.ORE_COAL_STONE, Blocks.ORE_COAL_BASALT, Blocks.ORE_COAL_LIMESTONE, Blocks.ORE_COAL_GRANITE));
        ITEM_GROUPS.register("minecraft:iron_ores", Registries.stackListOf(Blocks.ORE_IRON_STONE, Blocks.ORE_IRON_BASALT, Blocks.ORE_IRON_LIMESTONE, Blocks.ORE_IRON_GRANITE));
        ITEM_GROUPS.register("minecraft:gold_ores", Registries.stackListOf(Blocks.ORE_GOLD_STONE, Blocks.ORE_GOLD_BASALT, Blocks.ORE_GOLD_LIMESTONE, Blocks.ORE_GOLD_GRANITE));
        ITEM_GROUPS.register("minecraft:lapis_ores", Registries.stackListOf(Blocks.ORE_LAPIS_STONE, Blocks.ORE_LAPIS_BASALT, Blocks.ORE_LAPIS_LIMESTONE, Blocks.ORE_LAPIS_GRANITE));
        ITEM_GROUPS.register("minecraft:redstone_ores", Registries.stackListOf(Blocks.ORE_REDSTONE_STONE, Blocks.ORE_REDSTONE_BASALT, Blocks.ORE_REDSTONE_LIMESTONE, Blocks.ORE_REDSTONE_GRANITE, Blocks.ORE_REDSTONE_GLOWING_STONE, Blocks.ORE_REDSTONE_GLOWING_BASALT, Blocks.ORE_REDSTONE_GLOWING_LIMESTONE, Blocks.ORE_REDSTONE_GLOWING_GRANITE));
        ITEM_GROUPS.register("minecraft:diamond_ores", Registries.stackListOf(Blocks.ORE_DIAMOND_STONE, Blocks.ORE_DIAMOND_BASALT, Blocks.ORE_DIAMOND_LIMESTONE, Blocks.ORE_DIAMOND_GRANITE));
        ITEM_GROUPS.register("minecraft:nethercoal_ores", Registries.stackListOf(Blocks.ORE_NETHERCOAL_NETHERRACK));
        ITEM_GROUPS.register("minecraft:chests", Registries.stackListOf(Blocks.CHEST_PLANKS_OAK, new ItemStack(Blocks.CHEST_PLANKS_OAK_PAINTED, 1, 0), new ItemStack(Blocks.CHEST_PLANKS_OAK_PAINTED, 1, 16), new ItemStack(Blocks.CHEST_PLANKS_OAK_PAINTED, 1, 32), new ItemStack(Blocks.CHEST_PLANKS_OAK_PAINTED, 1, 48), new ItemStack(Blocks.CHEST_PLANKS_OAK_PAINTED, 1, 64), new ItemStack(Blocks.CHEST_PLANKS_OAK_PAINTED, 1, 80), new ItemStack(Blocks.CHEST_PLANKS_OAK_PAINTED, 1, 96), new ItemStack(Blocks.CHEST_PLANKS_OAK_PAINTED, 1, 112), new ItemStack(Blocks.CHEST_PLANKS_OAK_PAINTED, 1, 128), new ItemStack(Blocks.CHEST_PLANKS_OAK_PAINTED, 1, 144), new ItemStack(Blocks.CHEST_PLANKS_OAK_PAINTED, 1, 160), new ItemStack(Blocks.CHEST_PLANKS_OAK_PAINTED, 1, 176), new ItemStack(Blocks.CHEST_PLANKS_OAK_PAINTED, 1, 192), new ItemStack(Blocks.CHEST_PLANKS_OAK_PAINTED, 1, 208), new ItemStack(Blocks.CHEST_PLANKS_OAK_PAINTED, 1, 224), new ItemStack(Blocks.CHEST_PLANKS_OAK_PAINTED, 1, 240)));
        ITEM_GROUPS.register("minecraft:wools", Registries.stackListOf(new ItemStack(Blocks.WOOL, 1, 0), new ItemStack(Blocks.WOOL, 1, 1), new ItemStack(Blocks.WOOL, 1, 2), new ItemStack(Blocks.WOOL, 1, 3), new ItemStack(Blocks.WOOL, 1, 4), new ItemStack(Blocks.WOOL, 1, 5), new ItemStack(Blocks.WOOL, 1, 6), new ItemStack(Blocks.WOOL, 1, 7), new ItemStack(Blocks.WOOL, 1, 8), new ItemStack(Blocks.WOOL, 1, 9), new ItemStack(Blocks.WOOL, 1, 10), new ItemStack(Blocks.WOOL, 1, 11), new ItemStack(Blocks.WOOL, 1, 12), new ItemStack(Blocks.WOOL, 1, 13), new ItemStack(Blocks.WOOL, 1, 14), new ItemStack(Blocks.WOOL, 1, 15)));
        ITEM_GROUPS.register("minecraft:lamps", Registries.stackListOf(new ItemStack(Blocks.LAMP_IDLE, 1, 0), new ItemStack(Blocks.LAMP_IDLE, 1, 1), new ItemStack(Blocks.LAMP_IDLE, 1, 2), new ItemStack(Blocks.LAMP_IDLE, 1, 3), new ItemStack(Blocks.LAMP_IDLE, 1, 4), new ItemStack(Blocks.LAMP_IDLE, 1, 5), new ItemStack(Blocks.LAMP_IDLE, 1, 6), new ItemStack(Blocks.LAMP_IDLE, 1, 7), new ItemStack(Blocks.LAMP_IDLE, 1, 8), new ItemStack(Blocks.LAMP_IDLE, 1, 9), new ItemStack(Blocks.LAMP_IDLE, 1, 10), new ItemStack(Blocks.LAMP_IDLE, 1, 11), new ItemStack(Blocks.LAMP_IDLE, 1, 12), new ItemStack(Blocks.LAMP_IDLE, 1, 13), new ItemStack(Blocks.LAMP_IDLE, 1, 14), new ItemStack(Blocks.LAMP_IDLE, 1, 15)));
        if (RECIPES == null) {
            new RecipeRegistry();
        }
    }

    public static List<ItemStack> stackListOf(Object ... items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Object item : items) {
            if (item instanceof Block) {
                list.add(new ItemStack((Block)item));
                continue;
            }
            if (item instanceof Item) {
                list.add(new ItemStack((Item)item));
                continue;
            }
            if (item instanceof ItemStack) {
                list.add(new ItemStack((ItemStack)item));
                continue;
            }
            if (!(item instanceof Collection)) continue;
            list.addAll(Registries.stackListOf(((Collection)item).toArray(new Object[0])));
        }
        return list;
    }

    public static Registries getInstance() {
        return INSTANCE;
    }

    static {
        init = false;
    }
}

