/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.projectile;

import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.projectile.CannonballProjectile;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;

public class CannonballBouncyProjectile
extends CannonballProjectile {
    private int fuse = 50;

    public CannonballBouncyProjectile(World world, Mob owner) {
        super(world, owner);
        this.x += this.xd;
        this.y += this.yd;
        this.z += this.zd;
        this.setHeading(this.xd, this.yd, this.zd, 0.75f, 0.0f);
        this.defaultGravity = 0.06f;
    }

    public CannonballBouncyProjectile(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.defaultGravity = 0.06f;
    }

    @Override
    public void tick() {
        List<Entity> collidingEntities;
        Vec3 nextPos;
        this.baseTick();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float f = MathHelper.sqrt(this.xd * this.xd + this.zd * this.zd);
            this.yRotO = this.yRot = (float)(Math.atan2(this.xd, this.zd) * 180.0 / Math.PI);
            this.xRotO = this.xRot = (float)(Math.atan2(this.yd, f) * 180.0 / Math.PI);
        }
        float velocity = MathHelper.sqrt(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd);
        Vec3 currentPos = Vec3.getTempVec3(this.x, this.y, this.z);
        HitResult hit = this.world.checkBlockCollisionBetweenPoints(currentPos, nextPos = Vec3.getTempVec3(this.x + this.xd, this.y + this.yd - 0.25, this.z + this.zd), false, true);
        if (hit != null && hit.hitType == HitResult.HitType.TILE) {
            float bounceAxisScale = 0.4f;
            float otherAxisScale = 0.6f;
            float minVelocity = 0.2f;
            Side side = hit.side;
            if (side == Side.TOP && (Math.abs(this.yd) < 0.25 || velocity < minVelocity)) {
                this.yd = 0.0;
                this.y = (float)hit.y + 1.0f + 0.25f;
                this.xd = 0.0;
                this.zd = 0.0;
                return;
            }
            if (side.getAxis() == Axis.Y) {
                this.yd = -this.yd * (double)bounceAxisScale;
                this.xd *= (double)otherAxisScale;
                this.zd *= (double)otherAxisScale;
                this.world.playSoundAtEntity(null, this, "random.explode", 0.25f * velocity, 2.0f);
            }
            if (side.getAxis() == Axis.X) {
                this.xd = -this.xd * (double)bounceAxisScale;
                this.yd *= (double)otherAxisScale;
                this.zd *= (double)otherAxisScale;
                this.world.playSoundAtEntity(null, this, "random.explode", 0.25f * velocity, 2.0f);
            }
            if (side.getAxis() == Axis.Z) {
                this.zd = -this.zd * (double)bounceAxisScale;
                this.xd *= (double)otherAxisScale;
                this.yd *= (double)otherAxisScale;
                this.world.playSoundAtEntity(null, this, "random.explode", 0.25f * velocity, 2.0f);
            }
        }
        if (((collidingEntities = this.world.getEntitiesWithinAABBExcludingEntity(this, this.bb.cloneMove(this.xd, this.yd, this.zd))) != null && collidingEntities.size() > 0 || this.fuse <= 0) && (collidingEntities == null || collidingEntities.size() != 1 || collidingEntities.get(0) != this.owner || this.tickCount >= 4)) {
            this.world.newExplosion(this.owner, this.x, this.y, this.z, 1.5f, false, true);
            this.remove();
            return;
        }
        this.x += this.xd;
        this.y += this.yd;
        this.z += this.zd;
        float velocityHorizontal = MathHelper.sqrt(this.xd * this.xd + this.zd * this.zd);
        this.yRot = (float)(Math.atan2(this.xd, this.zd) * 180.0 / Math.PI);
        this.xRot = (float)(Math.atan2(this.yd, velocityHorizontal) * 180.0 / Math.PI);
        while (this.xRot - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.xRot - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.yRot - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.yRot - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        this.xRot = this.xRotO + (this.xRot - this.xRotO) * 0.2f;
        this.yRot = this.yRotO + (this.yRot - this.yRotO) * 0.2f;
        float deceleration = 0.99f;
        float gravity = 0.06f;
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                double particleDistance = 0.25;
                this.world.spawnParticle("bubble", this.x - this.xd * particleDistance, this.y - this.yd * particleDistance, this.z - this.zd * particleDistance, this.xd, this.yd, this.zd, 0);
            }
            deceleration = 0.8f;
        }
        this.world.spawnParticle("largesmoke", this.x, this.y, this.z, 0.0, 0.0, 0.0, 0);
        this.xd *= (double)deceleration;
        this.yd *= (double)deceleration;
        this.zd *= (double)deceleration;
        this.yd -= (double)gravity;
        this.setPos(this.x, this.y, this.z);
        --this.fuse;
    }
}

