/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.item.material.ArmorMaterial;
import net.minecraft.core.player.inventory.slot.Slot;
import org.jetbrains.annotations.Nullable;

public class QuiverItem
extends Item
implements IArmorItem {
    public QuiverItem(String name, String namespaceId, int id) {
        super(name, namespaceId, id);
        this.setMaxStackSize(1);
        this.setMaxDamage(192);
    }

    @Override
    public boolean hasInventoryInteraction() {
        return true;
    }

    @Override
    public ItemStack onInventoryInteract(Player player, Slot slot, ItemStack stackInSlot, boolean isItemGrabbed) {
        ItemStack quiverItem = isItemGrabbed ? player.inventory.getHeldItemStack() : stackInSlot;
        int totalSpace = this.getMaxDamage();
        int arrowCount = this.getArrowCount(quiverItem);
        int freeSpace = totalSpace - arrowCount;
        if (isItemGrabbed) {
            int amount;
            if (stackInSlot == null) {
                ItemStack arrowStack;
                int amount2 = Math.min(64, arrowCount);
                if (amount2 > 0 && slot.mayPlace(arrowStack = new ItemStack(Items.AMMO_ARROW, amount2, 0))) {
                    this.setArrowCount(quiverItem, arrowCount - amount2);
                    stackInSlot = arrowStack;
                }
            } else if (stackInSlot != null && stackInSlot.itemID == Items.AMMO_ARROW.id && (amount = Math.min(freeSpace, stackInSlot.stackSize)) > 0) {
                this.setArrowCount(quiverItem, arrowCount + amount);
                stackInSlot.stackSize -= amount;
            }
        } else {
            int amount;
            ItemStack grabbedItem = player.inventory.getHeldItemStack();
            if (grabbedItem != null && grabbedItem.itemID == Items.AMMO_ARROW.id) {
                int amount3 = Math.min(grabbedItem.stackSize, freeSpace);
                if (amount3 > 0) {
                    grabbedItem.stackSize -= amount3;
                    this.setArrowCount(quiverItem, arrowCount + amount3);
                    if (grabbedItem.stackSize <= 0) {
                        player.inventory.setHeldItemStack(null);
                    }
                }
            } else if (grabbedItem == null && (amount = Math.min(64, arrowCount)) > 0) {
                this.setArrowCount(quiverItem, arrowCount - amount);
                player.inventory.setHeldItemStack(new ItemStack(Items.AMMO_ARROW, amount, 0));
            }
        }
        return stackInSlot;
    }

    private int getArrowCount(ItemStack stack) {
        return stack.getMaxDamage() - stack.getMetadata();
    }

    private void setArrowCount(ItemStack stack, int count) {
        stack.setMetadata(stack.getMaxDamage() - count);
    }

    @Override
    public boolean showFullDurability() {
        return true;
    }

    @Override
    @Nullable
    public ArmorMaterial getArmorMaterial() {
        return null;
    }

    @Override
    public int getArmorPiece() {
        return 1;
    }
}

