/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import net.minecraft.core.data.gamerule.GameRule;
import net.minecraft.core.data.gamerule.GameRuleCollection;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.ServerCommandHandler;
import net.minecraft.core.net.packet.GameRulePacket;

public class GameruleCommand
extends Command {
    public GameruleCommand() {
        super("gamerule", "gr");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length != 1 && args.length != 2) {
            return false;
        }
        if (args[0].equalsIgnoreCase("list")) {
            sender.sendMessage("List of game rules:");
            for (GameRule<?> gameRule : Registries.GAME_RULES) {
                sender.sendMessage(" - " + gameRule.getKey());
            }
            return true;
        }
        GameRule<?> gameRule = null;
        for (GameRule<?> gr : Registries.GAME_RULES) {
            if (!gr.getKey().equalsIgnoreCase(args[0])) continue;
            gameRule = gr;
            break;
        }
        if (gameRule == null) {
            throw new CommandError("Can't find game rule \"" + args[0] + "\"!");
        }
        GameRuleCollection gameRules = handler.getWorld(0).getLevelData().getGameRules();
        if (args.length == 1) {
            handler.sendCommandFeedback(sender, "Value of game rule \"" + gameRule.getKey() + "\" is " + gameRules.getValue(gameRule) + ".");
            return true;
        }
        String valStr = args[1];
        Object o = gameRule.parseFromString(valStr);
        if (o == null) {
            throw new CommandError("Could not parse value!");
        }
        gameRules.setValue(gameRule, o);
        handler.sendCommandFeedback(sender, "Value of game rule \"" + gameRule.getKey() + "\" was set to " + gameRules.getValue(gameRule) + ".");
        if (handler.isServer()) {
            ServerCommandHandler serverHandler = (ServerCommandHandler)handler;
            serverHandler.minecraftServer.playerList.sendPacketToAllPlayers(new GameRulePacket(gameRules));
        }
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        handler.sendCommandFeedback(sender, "/gamerule list");
        handler.sendCommandFeedback(sender, "/gamerule <rule>");
        handler.sendCommandFeedback(sender, "/gamerule <rule> <value>");
    }
}

