/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.servercommands;

import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.ServerCommand;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.ServerPlayer;

public class BanCommand
extends ServerCommand {
    public BanCommand(MinecraftServer server) {
        super(server, "ban", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length != 1) {
            return false;
        }
        String senderName = sender.getName();
        String nameToBan = args[0];
        this.server.playerList.banPlayer(nameToBan);
        this.sendNoticeToOps(senderName, "Banning " + nameToBan);
        ServerPlayer player = this.server.playerList.getPlayerEntity(nameToBan);
        if (player != null) {
            player.playerNetServerHandler.kickPlayer("Banned by admin");
        }
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/ban <username>");
    }
}

