/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.season.SeasonManager;

public class ChunkCache
implements WorldSource {
    private final int chunkX;
    private final int chunkZ;
    private final Chunk[][] chunkArray;
    private final World worldObj;

    public ChunkCache(World world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.worldObj = world;
        this.chunkX = Math.floorDiv(minX, 16);
        this.chunkZ = Math.floorDiv(minZ, 16);
        int maxChunkX = Math.floorDiv(maxX, 16);
        int maxChunkZ = Math.floorDiv(maxZ, 16);
        this.chunkArray = new Chunk[maxChunkX - this.chunkX + 1][maxChunkZ - this.chunkZ + 1];
        for (int x = this.chunkX; x <= maxChunkX; ++x) {
            for (int z = this.chunkZ; z <= maxChunkZ; ++z) {
                this.chunkArray[x - this.chunkX][z - this.chunkZ] = world.getChunkFromChunkCoords(x, z);
            }
        }
    }

    @Override
    public int getBlockId(int x, int y, int z) {
        if (y < 0) {
            return 0;
        }
        if (y >= this.worldObj.getHeightBlocks()) {
            return 0;
        }
        int l = Math.floorDiv(x, 16) - this.chunkX;
        int i1 = Math.floorDiv(z, 16) - this.chunkZ;
        if (l < 0 || l >= this.chunkArray.length || i1 < 0 || i1 >= this.chunkArray[l].length) {
            return 0;
        }
        Chunk chunk = this.chunkArray[l][i1];
        if (chunk == null) {
            return 0;
        }
        return chunk.getBlockID(x & 0xF, y, z & 0xF);
    }

    @Override
    public Block getBlock(int x, int y, int z) {
        return Block.getBlock(this.getBlockId(x, y, z));
    }

    @Override
    public BlockEntity getBlockEntity(int x, int y, int z) {
        int l = Math.floorDiv(x, 16) - this.chunkX;
        int i1 = Math.floorDiv(z, 16) - this.chunkZ;
        return this.chunkArray[l][i1].getBlockEntity(x & 0xF, y, z & 0xF);
    }

    public boolean getBlockLitInteriorSurface(int i, int j, int k) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return true;
        }
        if (j < 0) {
            return true;
        }
        if (j >= this.worldObj.getHeightBlocks()) {
            return true;
        }
        return Block.getIsLitInteriorSurface(this.worldObj, i, j, k);
    }

    @Override
    public float getBrightness(int x, int y, int z, int blockLightValue) {
        int i1 = this.getLightValue(x, y, z);
        if (i1 < blockLightValue) {
            i1 = blockLightValue;
        }
        return this.worldObj.worldType.getBrightnessRamp()[i1];
    }

    @Override
    public int getLightmapCoord(int x, int y, int z, int blockLightValue) {
        int skyLight = this.worldObj.getSavedLightValue(LightLayer.Sky, x, y, z);
        int blockLight = Math.max(this.worldObj.getSavedLightValue(LightLayer.Block, x, y, z), blockLightValue);
        if (this.getBlockLitInteriorSurface(x, y, z)) {
            skyLight = Math.max(skyLight, this.worldObj.getSavedLightValue(LightLayer.Sky, x, y + 1, z));
            skyLight = Math.max(skyLight, this.worldObj.getSavedLightValue(LightLayer.Sky, x, y - 1, z));
            skyLight = Math.max(skyLight, this.worldObj.getSavedLightValue(LightLayer.Sky, x + 1, y, z));
            skyLight = Math.max(skyLight, this.worldObj.getSavedLightValue(LightLayer.Sky, x - 1, y, z));
            skyLight = Math.max(skyLight, this.worldObj.getSavedLightValue(LightLayer.Sky, x, y, z + 1));
            skyLight = Math.max(skyLight, this.worldObj.getSavedLightValue(LightLayer.Sky, x, y, z - 1));
            blockLight = Math.max(blockLight, this.worldObj.getSavedLightValue(LightLayer.Block, x, y + 1, z));
            blockLight = Math.max(blockLight, this.worldObj.getSavedLightValue(LightLayer.Block, x, y - 1, z));
            blockLight = Math.max(blockLight, this.worldObj.getSavedLightValue(LightLayer.Block, x + 1, y, z));
            blockLight = Math.max(blockLight, this.worldObj.getSavedLightValue(LightLayer.Block, x - 1, y, z));
            blockLight = Math.max(blockLight, this.worldObj.getSavedLightValue(LightLayer.Block, x, y, z + 1));
            blockLight = Math.max(blockLight, this.worldObj.getSavedLightValue(LightLayer.Block, x, y, z - 1));
        }
        return LightmapHelper.getLightmapCoord(skyLight, blockLight);
    }

    @Override
    public float getLightBrightness(int x, int y, int z) {
        return this.worldObj.worldType.getBrightnessRamp()[this.getLightValue(x, y, z)];
    }

    public int getLightValue(int i, int j, int k) {
        return this.getLightValueExt(i, j, k, true);
    }

    public int getLightValueExt(int i, int j, int k, boolean flag) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return 15;
        }
        if (flag && this.getBlockLitInteriorSurface(i, j, k)) {
            int k1 = this.getLightValueExt(i, j + 1, k, false);
            int i2 = this.getLightValueExt(i + 1, j, k, false);
            int j2 = this.getLightValueExt(i - 1, j, k, false);
            int k2 = this.getLightValueExt(i, j, k + 1, false);
            int l2 = this.getLightValueExt(i, j, k - 1, false);
            if (i2 > k1) {
                k1 = i2;
            }
            if (j2 > k1) {
                k1 = j2;
            }
            if (k2 > k1) {
                k1 = k2;
            }
            if (l2 > k1) {
                k1 = l2;
            }
            return k1;
        }
        if (j < 0) {
            return 0;
        }
        if (j >= this.worldObj.getHeightBlocks()) {
            int i1 = 15 - this.worldObj.skyDarken;
            if (i1 < 0) {
                i1 = 0;
            }
            return i1;
        }
        int j1 = Math.floorDiv(i, 16) - this.chunkX;
        int l1 = Math.floorDiv(k, 16) - this.chunkZ;
        return this.chunkArray[j1][l1].getRawBrightness(i & 0xF, j, k & 0xF, this.worldObj.skyDarken);
    }

    @Override
    public int getBlockMetadata(int x, int y, int z) {
        if (y < 0) {
            return 0;
        }
        if (y >= this.worldObj.getHeightBlocks()) {
            return 0;
        }
        int chunkX = Math.floorDiv(x, 16) - this.chunkX;
        int chunkZ = Math.floorDiv(z, 16) - this.chunkZ;
        return this.chunkArray[chunkX][chunkZ].getBlockMetadata(x & 0xF, y, z & 0xF);
    }

    @Override
    public Material getBlockMaterial(int x, int y, int z) {
        int l = this.getBlockId(x, y, z);
        if (l == 0) {
            return Material.air;
        }
        return Block.blocksList[l].blockMaterial;
    }

    @Override
    public boolean isBlockOpaqueCube(int x, int y, int z) {
        Block block = Block.blocksList[this.getBlockId(x, y, z)];
        if (block == null) {
            return false;
        }
        return block.isSolidRender();
    }

    @Override
    public boolean isBlockNormalCube(int x, int y, int z) {
        Block block = Block.blocksList[this.getBlockId(x, y, z)];
        if (block == null) {
            return false;
        }
        return block.blockMaterial.blocksMotion() && block.isCubeShaped();
    }

    @Override
    public double getBlockTemperature(int x, int z) {
        return this.worldObj.getBlockTemperature(x, z);
    }

    @Override
    public double getBlockHumidity(int x, int z) {
        return this.worldObj.getBlockHumidity(x, z);
    }

    @Override
    public SeasonManager getSeasonManager() {
        return this.worldObj.getSeasonManager();
    }

    @Override
    public Biome getBlockBiome(int x, int y, int z) {
        return this.worldObj.getBlockBiome(x, y, z);
    }

    @Override
    public int getSavedLightValue(LightLayer layer, int x, int y, int z) {
        return this.worldObj.getSavedLightValue(layer, x, y, z);
    }
}

