/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Random;
import net.minecraft.core.block.BaseLeavesBlock;
import net.minecraft.core.block.Block;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.MethodParametersAnnotation;
import net.minecraft.core.world.generate.feature.WorldFeature;

public class WorldFeatureMeadow
extends WorldFeature {
    private final int[] blockIds;

    @MethodParametersAnnotation(names={"blockIds"})
    public WorldFeatureMeadow(int[] blockIds) {
        this.blockIds = blockIds;
    }

    @Override
    public boolean place(World world, Random random, int x, int y, int z) {
        int l = 0;
        while (((l = world.getBlockId(x, y, z)) == 0 || Block.blocksList[l] instanceof BaseLeavesBlock) && y > 0) {
            --y;
        }
        for (int i1 = 0; i1 < 128; ++i1) {
            int j1 = x + random.nextInt(8) - random.nextInt(8);
            int k1 = y + random.nextInt(4) - random.nextInt(4);
            int l1 = z + random.nextInt(8) - random.nextInt(8);
            int meta = 0;
            int index = random.nextInt(this.blockIds.length);
            int flowerId = this.blockIds[index];
            if (!world.isAirBlock(j1, k1, l1) || !Block.blocksList[flowerId].canBlockStay(world, j1, k1, l1)) continue;
            world.setBlockAndMetadata(j1, k1, l1, flowerId, meta);
        }
        return true;
    }
}

