/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net;

import net.minecraft.core.net.ServerCommandEntry;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.Commands;
import net.minecraft.core.net.command.ConsoleCommandSender;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.server.MinecraftServer;

public class ConsoleCommandHandler {
    private final MinecraftServer minecraftServer;
    public final ConsoleCommandSender sender;

    public ConsoleCommandHandler(MinecraftServer server) {
        this.minecraftServer = server;
        Commands.initServerCommands(server);
        this.sender = new ConsoleCommandSender(server);
    }

    public void handleCommand(ServerCommandEntry serverCommandEntry) {
        System.out.println("ServerCommand: " + serverCommandEntry.command);
        String[] args = serverCommandEntry.command.split(" ");
        String[] args1 = new String[args.length - 1];
        System.arraycopy(args, 1, args1, 0, args.length - 1);
        for (Command command : Commands.commands) {
            if (!command.isName(args[0])) continue;
            try {
                boolean success = command.execute(this.minecraftServer.serverCommandHandler, this.sender, args1);
                if (!success) {
                    command.sendCommandSyntax(this.minecraftServer.serverCommandHandler, this.sender);
                }
            }
            catch (CommandError e) {
                this.sender.sendMessage(TextFormatting.RED + e.getMessage());
            }
            return;
        }
        this.sender.sendMessage(TextFormatting.RED + "Command '" + args[0] + "' does not exist!");
    }
}

