/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.packet.BedMessagePacket;
import net.minecraft.core.net.packet.ChatPacket;
import net.minecraft.core.net.packet.GameRulePacket;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PlayerGamemodePacket;
import net.minecraft.core.net.packet.RespawnPacket;
import net.minecraft.core.net.packet.SetTimePacket;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.PortalHandler;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.save.PlayerIO;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.ServerPlayer;
import net.minecraft.server.net.handler.LoginPacketHandler;
import net.minecraft.server.player.PlayerManager;
import net.minecraft.server.world.ServerPlayerController;
import net.minecraft.server.world.WorldServer;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PlayerList {
    public static Logger logger = Logger.getLogger("Minecraft");
    public List<ServerPlayer> playerEntities = new ArrayList<ServerPlayer>();
    private final MinecraftServer server;
    private final PlayerManager[] playerManagers;
    private final Set<String> bans = new HashSet<String>();
    private final Set<String> ipBans = new HashSet<String>();
    private final Set<String> ops = new HashSet<String>();
    private final Set<String> whitelist = new HashSet<String>();
    private final File bansFile;
    private final File ipBansFile;
    private final File opsFile;
    private final File whitelistFile;
    private PlayerIO playerIo;
    private final boolean whitelistEnforced;

    public PlayerList(MinecraftServer server) {
        this.playerManagers = new PlayerManager[Dimension.getDimensionList().size()];
        this.server = server;
        this.bansFile = server.getFile("banned-players.txt");
        this.ipBansFile = server.getFile("banned-ips.txt");
        this.opsFile = server.getFile("ops.txt");
        this.whitelistFile = server.getFile("white-list.txt");
        int viewDistance = server.propertyManager.getIntProperty("view-distance", 10);
        for (int dim = 0; dim < Dimension.getDimensionList().size(); ++dim) {
            this.playerManagers[dim] = new PlayerManager(server, dim, viewDistance);
        }
        this.whitelistEnforced = server.propertyManager.getBooleanProperty("white-list", false);
        this.readBannedPlayers();
        this.loadBannedList();
        this.loadOps();
        this.loadWhiteList();
        this.writeBannedPlayers();
        this.saveBannedList();
        this.saveOps();
        this.saveWhiteList();
    }

    public void setPlayerManager(WorldServer[] aworldserver) {
        this.playerIo = aworldserver[0].getSaveHandler().getPlayerFileData();
    }

    public void func_28172_a(ServerPlayer player) {
        for (PlayerManager playerManager : this.playerManagers) {
            playerManager.removePlayer(player);
        }
        this.getPlayerManager(player.dimension).addPlayer(player);
        WorldServer world = this.server.getDimensionWorld(player.dimension);
        world.chunkProviderServer.prepareChunk((int)player.x >> 4, (int)player.z >> 4);
    }

    public int getMaxTrackingDistance() {
        return this.playerManagers[0].getMaxTrackingDistance();
    }

    public PlayerManager getPlayerManager(int dim) {
        return this.playerManagers[dim];
    }

    public void load(ServerPlayer player) {
        this.playerIo.load(player);
    }

    public void playerLoggedIn(ServerPlayer player) {
        this.playerEntities.add(player);
        player.playerNetServerHandler.handleSendInitialPlayerList();
        WorldServer world = this.server.getDimensionWorld(player.dimension);
        world.chunkProviderServer.prepareChunk((int)player.x >> 4, (int)player.z >> 4);
        if (!world.getWorldType().hasCeiling()) {
            while (world.getCollidingSolidBlockBoundingBoxes(player, player.bb).size() != 0) {
                player.setPos(player.x, player.y + 1.0, player.z);
            }
        }
        world.entityJoinedWorld(player);
        this.getPlayerManager(player.dimension).addPlayer(player);
    }

    public void func_613_b(ServerPlayer entityplayermp) {
        this.getPlayerManager(entityplayermp.dimension).func_543_c(entityplayermp);
    }

    public void playerLoggedOut(ServerPlayer entityplayermp) {
        this.playerIo.save(entityplayermp);
        this.server.getDimensionWorld(entityplayermp.dimension).setEntityDead(entityplayermp);
        this.playerEntities.remove(entityplayermp);
        this.getPlayerManager(entityplayermp.dimension).removePlayer(entityplayermp);
    }

    public ServerPlayer getPlayerForLogin(LoginPacketHandler handler, String username) {
        if (this.bans.contains(username.trim().toLowerCase())) {
            handler.kickUser("You are banned from this server!");
            return null;
        }
        if (!this.isAllowedToLogin(username)) {
            handler.kickUser("You are not white-listed on this server!");
            return null;
        }
        String ip = handler.netManager.getRemoteAddress().toString();
        ip = ip.substring(ip.indexOf("/") + 1);
        if (this.ipBans.contains(ip = ip.substring(0, ip.indexOf(":")))) {
            handler.kickUser("Your IP address is banned from this server!");
            return null;
        }
        if (this.playerEntities.size() >= MinecraftServer.getInstance().maxPlayers) {
            handler.kickUser("The server is full!");
            return null;
        }
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            ServerPlayer player = this.playerEntities.get(i);
            if (!player.username.equalsIgnoreCase(username)) continue;
            player.playerNetServerHandler.kickPlayer("You are logged in from another location!");
        }
        return new ServerPlayer(this.server, this.server.getDimensionWorld(0), username, new ServerPlayerController(this.server.getDimensionWorld(0)));
    }

    public ServerPlayer recreatePlayerEntity(ServerPlayer previousPlayer, int i) {
        this.server.getEntityTracker(previousPlayer.dimension).removeTrackedPlayerSymmetric(previousPlayer);
        this.server.getEntityTracker(previousPlayer.dimension).untrackEntity(previousPlayer);
        this.getPlayerManager(previousPlayer.dimension).removePlayer(previousPlayer);
        this.playerEntities.remove(previousPlayer);
        this.server.getDimensionWorld(previousPlayer.dimension).removePlayer(previousPlayer);
        ChunkCoordinates chunkcoordinates = previousPlayer.getPlayerSpawnCoordinate();
        previousPlayer.dimension = i;
        ServerPlayer newPlayer = new ServerPlayer(this.server, this.server.getDimensionWorld(previousPlayer.dimension), previousPlayer.username, new ServerPlayerController(this.server.getDimensionWorld(previousPlayer.dimension)));
        newPlayer.id = previousPlayer.id;
        newPlayer.chatColor = previousPlayer.chatColor;
        newPlayer.nickname = previousPlayer.nickname;
        newPlayer.gamemode = previousPlayer.gamemode;
        newPlayer.playerNetServerHandler = previousPlayer.playerNetServerHandler;
        newPlayer.inventory.transferAllContents(previousPlayer.inventory);
        WorldServer worldserver = this.server.getDimensionWorld(previousPlayer.dimension);
        if (chunkcoordinates != null) {
            ChunkCoordinates chunkcoordinates1 = Player.getValidBedSpawnCoordinates(this.server.getDimensionWorld(previousPlayer.dimension), chunkcoordinates);
            if (chunkcoordinates1 != null) {
                newPlayer.moveTo((float)chunkcoordinates1.x + 0.5f, (float)chunkcoordinates1.y + 0.1f, (float)chunkcoordinates1.z + 0.5f, 0.0f, 0.0f);
                newPlayer.setPlayerSpawnCoordinate(chunkcoordinates);
            } else {
                newPlayer.playerNetServerHandler.sendPacket(new BedMessagePacket(0));
            }
        }
        worldserver.chunkProviderServer.prepareChunk((int)newPlayer.x >> 4, (int)newPlayer.z >> 4);
        while (worldserver.getCubes(newPlayer, newPlayer.bb).size() != 0) {
            newPlayer.setPos(newPlayer.x, newPlayer.y + 1.0, newPlayer.z);
        }
        newPlayer.playerNetServerHandler.sendPacket(new RespawnPacket((byte)newPlayer.dimension, (byte)Registries.WORLD_TYPES.getNumericIdOfItem(worldserver.worldType)));
        this.server.playerList.sendPacketToAllPlayers(new PlayerGamemodePacket(newPlayer.id, newPlayer.gamemode.getId()));
        newPlayer.playerNetServerHandler.teleportAndRotate(newPlayer.x, newPlayer.y, newPlayer.z, newPlayer.yRot, newPlayer.xRot);
        this.func_28170_a(newPlayer, worldserver);
        this.getPlayerManager(newPlayer.dimension).addPlayer(newPlayer);
        worldserver.entityJoinedWorld(newPlayer);
        this.playerEntities.add(newPlayer);
        newPlayer.func_20057_k();
        newPlayer.func_22068_s();
        newPlayer.playerNetServerHandler.sendPacket(new GameRulePacket(this.server.getDimensionWorld(0).getLevelData().getGameRules()));
        return newPlayer;
    }

    public void sendPlayerToOtherDimension(ServerPlayer serverPlayer, int targetDim, boolean generatePortal) {
        double dz;
        double dy;
        double dx;
        double distSqr;
        WorldServer worldserver = this.server.getDimensionWorld(serverPlayer.dimension);
        Dimension lastDim = Dimension.getDimensionList().get(serverPlayer.dimension);
        Dimension newDim = Dimension.getDimensionList().get(targetDim);
        serverPlayer.dimension = targetDim;
        WorldServer worldserver1 = this.server.getDimensionWorld(serverPlayer.dimension);
        serverPlayer.playerNetServerHandler.sendPacket(new RespawnPacket((byte)serverPlayer.dimension, (byte)Registries.WORLD_TYPES.getNumericIdOfItem(worldserver1.worldType)));
        worldserver.removePlayer(serverPlayer);
        serverPlayer.removed = false;
        double x = serverPlayer.x;
        double y = serverPlayer.y;
        double z = serverPlayer.z;
        serverPlayer.moveTo(x *= (double)Dimension.getCoordScale(lastDim, newDim), y, z *= (double)Dimension.getCoordScale(lastDim, newDim), serverPlayer.yRot, serverPlayer.xRot);
        ChunkCoordinates newCoordinates = new ChunkCoordinates(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
        if (serverPlayer.dimensionEnterCoordinate != null && (distSqr = (dx = (double)serverPlayer.dimensionEnterCoordinate.x - x) * dx + (dy = (double)serverPlayer.dimensionEnterCoordinate.y - y) * dy + (dz = (double)serverPlayer.dimensionEnterCoordinate.z - z) * dz) > 6.4E7) {
            serverPlayer.addStat(Achievements.FAST_TRAVEL, 1);
        }
        serverPlayer.dimensionEnterCoordinate = newCoordinates;
        if (serverPlayer.isAlive()) {
            worldserver.updateEntityWithOptionalForce(serverPlayer, false);
        }
        if (serverPlayer.isAlive()) {
            worldserver1.entityJoinedWorld(serverPlayer);
            serverPlayer.moveTo(x, serverPlayer.y, z, serverPlayer.yRot, serverPlayer.xRot);
            worldserver1.updateEntityWithOptionalForce(serverPlayer, false);
            if (generatePortal) {
                worldserver1.chunkProviderServer.chunkLoadOverride = true;
                new PortalHandler().teleportEntity(worldserver1, serverPlayer, lastDim, newDim);
                worldserver1.chunkProviderServer.chunkLoadOverride = false;
            }
        }
        this.func_28172_a(serverPlayer);
        serverPlayer.playerNetServerHandler.teleportAndRotate(serverPlayer.x, serverPlayer.y, serverPlayer.z, serverPlayer.yRot, serverPlayer.xRot);
        this.server.playerList.sendPacketToAllPlayers(new PlayerGamemodePacket(serverPlayer.id, serverPlayer.gamemode.getId()));
        serverPlayer.setWorld(worldserver1);
        this.func_28170_a(serverPlayer, worldserver1);
        this.func_30008_g(serverPlayer);
        serverPlayer.playerNetServerHandler.sendPacket(new GameRulePacket(this.server.getDimensionWorld(0).getLevelData().getGameRules()));
    }

    public void onTick() {
        for (int i = 0; i < this.playerManagers.length; ++i) {
            this.playerManagers[i].tick();
        }
    }

    public void markBlockNeedsUpdate(int i, int j, int k, int l) {
        this.getPlayerManager(l).markBlockNeedsUpdate(i, j, k);
    }

    public void sendPacketToAllPlayers(Packet packet) {
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            ServerPlayer entityplayermp = this.playerEntities.get(i);
            entityplayermp.playerNetServerHandler.sendPacket(packet);
        }
    }

    public void sendEncryptedChatToAllPlayers(String message) {
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            ServerPlayer entityplayermp = this.playerEntities.get(i);
            entityplayermp.playerNetServerHandler.sendPacket(new ChatPacket(message, 0, AES.keyChain.get(entityplayermp.username)));
        }
    }

    public void sendPacketToAllPlayersInDimension(Packet packet, int i) {
        for (int j = 0; j < this.playerEntities.size(); ++j) {
            ServerPlayer entityplayermp = this.playerEntities.get(j);
            if (entityplayermp.dimension != i) continue;
            entityplayermp.playerNetServerHandler.sendPacket(packet);
        }
    }

    public String getPlayerList() {
        String s = "";
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            if (i > 0) {
                s = s + ", ";
            }
            s = s + this.playerEntities.get(i).getDisplayName();
        }
        return s;
    }

    public void banPlayer(String s) {
        this.bans.add(s.toLowerCase());
        this.writeBannedPlayers();
    }

    public void pardonPlayer(String s) {
        this.bans.remove(s.toLowerCase());
        this.writeBannedPlayers();
    }

    private void readBannedPlayers() {
        try {
            this.bans.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.bansFile));
            String s = "";
            while ((s = bufferedreader.readLine()) != null) {
                this.bans.add(s.trim().toLowerCase());
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warn("Failed to load ban list: " + exception);
        }
    }

    private void writeBannedPlayers() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.bansFile, false));
            for (String s : this.bans) {
                printwriter.println(s);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warn("Failed to save ban list: " + exception);
        }
    }

    public void banIP(String s) {
        this.ipBans.add(s.toLowerCase());
        this.saveBannedList();
    }

    public void pardonIP(String s) {
        this.ipBans.remove(s.toLowerCase());
        this.saveBannedList();
    }

    private void loadBannedList() {
        try {
            this.ipBans.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.ipBansFile));
            String s = "";
            while ((s = bufferedreader.readLine()) != null) {
                this.ipBans.add(s.trim().toLowerCase());
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warn("Failed to load ip ban list: " + exception);
        }
    }

    private void saveBannedList() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.ipBansFile, false));
            for (String s : this.ipBans) {
                printwriter.println(s);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warn("Failed to save ip ban list: " + exception);
        }
    }

    public void opPlayer(String s) {
        this.ops.add(s.toLowerCase());
        this.saveOps();
    }

    public void deopPlayer(String s) {
        this.ops.remove(s.toLowerCase());
        this.saveOps();
    }

    private void loadOps() {
        try {
            this.ops.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.opsFile));
            String s = "";
            while ((s = bufferedreader.readLine()) != null) {
                this.ops.add(s.trim().toLowerCase());
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warn("Failed to load ip ban list: " + exception);
        }
    }

    private void saveOps() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.opsFile, false));
            for (String s : this.ops) {
                printwriter.println(s);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warn("Failed to save ip ban list: " + exception);
        }
    }

    private void loadWhiteList() {
        try {
            this.whitelist.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.whitelistFile));
            String s = "";
            while ((s = bufferedreader.readLine()) != null) {
                this.whitelist.add(s.trim().toLowerCase());
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warn("Failed to load white-list: " + exception);
        }
    }

    private void saveWhiteList() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.whitelistFile, false));
            for (String s : this.whitelist) {
                printwriter.println(s);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warn("Failed to save white-list: " + exception);
        }
    }

    public boolean isAllowedToLogin(String s) {
        s = s.trim().toLowerCase();
        return !this.whitelistEnforced || this.ops.contains(s) || this.whitelist.contains(s);
    }

    public boolean isOp(String s) {
        return this.ops.contains(s.trim().toLowerCase());
    }

    @Nullable
    public ServerPlayer getPlayerEntity(String s) {
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            ServerPlayer entityplayermp = this.playerEntities.get(i);
            if (!entityplayermp.username.equalsIgnoreCase(s)) continue;
            return entityplayermp;
        }
        return null;
    }

    public void sendChatMessageToPlayer(String s, String s1) {
        ServerPlayer entityplayermp = this.getPlayerEntity(s);
        if (entityplayermp != null) {
            entityplayermp.playerNetServerHandler.sendPacket(new ChatPacket(s1));
        }
    }

    public void sendPacketToPlayersAroundPoint(double x, double y, double z, double radius, int dimension, Packet packet) {
        this.sendPacketToOtherPlayersAroundPoint(null, x, y, z, radius, dimension, packet);
    }

    public void sendPacketToOtherPlayersAroundPoint(Player player, double x, double y, double z, double radius, int dimension, Packet packet) {
        for (ServerPlayer otherPlayer : this.playerEntities) {
            double dz;
            double dy;
            double dx;
            if (otherPlayer == player || otherPlayer.dimension != dimension || !((dx = x - otherPlayer.x) * dx + (dy = y - otherPlayer.y) * dy + (dz = z - otherPlayer.z) * dz < radius * radius)) continue;
            otherPlayer.playerNetServerHandler.sendPacket(packet);
        }
    }

    public void sendChatMessageToAllOps(String s) {
        ChatPacket chatPacket = new ChatPacket(s);
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            ServerPlayer entityplayermp = this.playerEntities.get(i);
            if (!this.isOp(entityplayermp.username)) continue;
            entityplayermp.playerNetServerHandler.sendPacket(chatPacket);
        }
    }

    public boolean sendPacketToPlayer(String s, Packet packet) {
        ServerPlayer entityplayermp = this.getPlayerEntity(s);
        if (entityplayermp != null) {
            entityplayermp.playerNetServerHandler.sendPacket(packet);
            return true;
        }
        return false;
    }

    public void savePlayerStates() {
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            this.playerIo.save(this.playerEntities.get(i));
        }
    }

    public void sendTileEntityToPlayer(int i, int j, int k, BlockEntity tileentity) {
    }

    public void addToWhiteList(String s) {
        this.whitelist.add(s);
        this.saveWhiteList();
    }

    public void removeFromWhiteList(String s) {
        this.whitelist.remove(s);
        this.saveWhiteList();
    }

    public Set<String> getWhitelist() {
        return this.whitelist;
    }

    public void reloadWhiteList() {
        this.loadWhiteList();
    }

    public void func_28170_a(ServerPlayer entityplayermp, WorldServer worldserver) {
        entityplayermp.playerNetServerHandler.sendPacket(new SetTimePacket(worldserver.getWorldTime()));
    }

    public void func_30008_g(ServerPlayer entityplayermp) {
        entityplayermp.func_28017_a(entityplayermp.inventorySlots);
        entityplayermp.func_30001_B();
    }
}

