/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.chat;

import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.chat.ChatEmotePickerElement;
import net.minecraft.client.gui.chat.ChatSuggestionsElement;
import net.minecraft.client.gui.chat.SleepScreenMP;
import net.minecraft.client.gui.hud.component.ComponentAnchor;
import net.minecraft.client.gui.text.ITextField;
import net.minecraft.client.gui.text.TextFieldEditor;
import net.minecraft.core.net.ChatEmotes;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ChatScreen
extends Screen
implements ITextField {
    protected String message;
    private int currentIndex = 0;
    private String originalMessage;
    private int updateCounter;
    private final TextFieldEditor editor;
    protected ChatEmotePickerElement emotePicker;
    protected boolean showEmotePicker = false;
    private ChatSuggestionsElement suggestionsElement;

    public ChatScreen() {
        this("");
    }

    public ChatScreen(String initialMessage) {
        this.message = initialMessage;
        this.updateCounter = 0;
        this.editor = new TextFieldEditor(this);
        this.editor.setCursor(10000);
    }

    @Override
    public void init() {
        Keyboard.enableRepeatEvents((boolean)true);
        int emotePickerYCells = (int)MathHelper.clamp(Math.ceil((double)ChatEmotes.getEmotes().size() / 5.0), 0.0, 4.0);
        this.emotePicker = new ChatEmotePickerElement(this.mc, this, 5, emotePickerYCells);
        this.showEmotePicker = false;
        this.suggestionsElement = new ChatSuggestionsElement(this.mc, this.editor, this, (parent, child, minecraft, followParameters) -> 16 + (followParameters ? this.suggestionsElement.getDefaultParameterPosition() - 1 : 0), (parent, child, minecraft, followParameters) -> minecraft.resolution.getScaledHeightScreenCoords() - 14, ComponentAnchor.BOTTOM_LEFT);
        if (!this.getText().startsWith("/")) {
            this.suggestionsElement.hidden = true;
        } else {
            this.suggestionsElement.updateSuggestions();
        }
    }

    @Override
    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.mc.ingameHud.chatScroll = 0;
    }

    @Override
    public void tick() {
        ++this.updateCounter;
        int dWheel = Mouse.getDWheel();
        if (dWheel != 0) {
            if (this.showEmotePicker) {
                this.emotePicker.scrollOffset((int)((float)(-dWheel) / 0.1f));
            } else {
                this.mc.ingameHud.chatScroll += dWheel / 1;
            }
        }
        if (this.suggestionsElement != null) {
            this.suggestionsElement.hidden = !this.getText().startsWith("/");
            this.suggestionsElement.updateScreen(dWheel);
        }
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        boolean handled = false;
        if (eventKey == Keyboard.KEY_UP) {
            if (this.suggestionsElement != null && this.suggestionsElement.getCommandIndex() != -1) {
                this.suggestionsElement.cycleThroughSuggestions(-1);
                handled = true;
            }
            if (!handled && !this.mc.thePlayer.messageHistory.isEmpty()) {
                if (this.currentIndex == 0) {
                    this.originalMessage = this.getText();
                }
                if (this.currentIndex < this.mc.thePlayer.messageHistory.size()) {
                    ++this.currentIndex;
                    this.setText(this.getMessage(this.currentIndex));
                    this.editor.setCursor(10000);
                }
                this.editor.setCursor(10000);
                if (this.suggestionsElement != null) {
                    this.suggestionsElement.updateSuggestions();
                }
                handled = true;
            }
        }
        if (eventKey == Keyboard.KEY_DOWN) {
            if (this.suggestionsElement != null && this.suggestionsElement.getCommandIndex() != -1) {
                this.suggestionsElement.cycleThroughSuggestions();
                handled = true;
            }
            if (!handled && this.currentIndex > 0) {
                if (this.currentIndex - 1 == 0) {
                    --this.currentIndex;
                    this.setText(this.originalMessage);
                    this.editor.setCursor(10000);
                } else {
                    --this.currentIndex;
                    this.setText(this.getMessage(this.currentIndex));
                    this.editor.setCursor(10000);
                }
                this.editor.setCursor(10000);
                if (this.suggestionsElement != null) {
                    this.suggestionsElement.updateSuggestions();
                }
                handled = true;
            }
        }
        if (eventKey == Keyboard.KEY_ESCAPE && !(this instanceof SleepScreenMP)) {
            this.mc.displayScreen(null);
            handled = true;
        }
        if (eventKey == Keyboard.KEY_RETURN) {
            String s = this.message.trim();
            if (s.length() > 0) {
                String s1 = this.message.trim();
                this.mc.thePlayer.sendChatMessage(s1);
            }
            this.mc.displayScreen(null);
            handled = true;
        }
        if (!handled) {
            this.editor.handleInput(eventKey, eventCharacter);
        }
        if (this.suggestionsElement != null) {
            this.suggestionsElement.keyTyped(eventCharacter, eventKey);
        }
    }

    @Override
    public void render(int xm, int ym, float partialTick) {
        int emotePickerButtonColor = Integer.MIN_VALUE;
        int emotePickerTextColor = 0xE0E0E0;
        if (xm >= 2 && xm < 14 && ym >= this.height - 14 && ym < this.height - 2) {
            emotePickerButtonColor = -2130706433;
            emotePickerTextColor = -96;
        }
        this.drawRect(2, this.height - 14, 14, this.height - 2, emotePickerButtonColor);
        this.drawStringCentered(this.font, Character.toString('\u263a'), 8, this.height - 12, emotePickerTextColor);
        this.drawRect(16, this.height - 14, this.width - 2, this.height - 2, Integer.MIN_VALUE);
        this.font.drawStringWithShadow(this.suggestionsElement.getSuggestionPreview(), 16 + this.suggestionsElement.getDefaultParameterPosition(), this.mc.resolution.getScaledHeightScreenCoords() - 12, 0xFFFFFF);
        boolean drawCursor = this.updateCounter / 6 % 2 == 0;
        int cursor = this.editor.getCursor();
        this.drawString(this.font, this.suggestionsElement.colorCodeText(this.message, true), 18, this.height - 12, 0xE0E0E0);
        if (drawCursor) {
            int width = this.font.getStringWidth(this.message);
            if (cursor < this.message.length()) {
                width = this.font.getStringWidth(this.message.substring(0, cursor));
            }
            this.drawString(this.font, "_", 18 + width, this.height - 12, 0xE0E0E0);
        }
        if (this.showEmotePicker) {
            this.emotePicker.draw(2, this.height - 16 - this.emotePicker.getHeight(), xm, ym);
        }
        super.render(xm, ym, partialTick);
        if (this.suggestionsElement != null) {
            this.suggestionsElement.drawScreen();
        }
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        boolean handled = false;
        if (buttonNum == 0) {
            Character c;
            if (mx >= 2 && mx < 14 && my >= this.height - 14 && my < this.height - 2) {
                this.showEmotePicker = !this.showEmotePicker;
                handled = true;
            }
            if (!handled && this.showEmotePicker && (c = this.emotePicker.click(mx - 2, my - (this.height - 16 - this.emotePicker.getHeight()))) != null) {
                this.editor.handleInput(0, c.charValue());
                if (!Keyboard.isKeyDown((int)Keyboard.KEY_LSHIFT) && !Keyboard.isKeyDown((int)Keyboard.KEY_RSHIFT)) {
                    this.showEmotePicker = false;
                }
                handled = true;
            }
            if (!handled && this.suggestionsElement != null) {
                this.suggestionsElement.mouseClicked(mx, my, buttonNum);
            }
        }
    }

    @Override
    public void setText(String text) {
        this.message = text;
    }

    @Override
    public String getText() {
        return this.message;
    }

    @Override
    public int maxLength() {
        return 256;
    }

    private String getMessage(int currentIndex) {
        return (String)this.mc.thePlayer.messageHistory.get(this.mc.thePlayer.messageHistory.size() - currentIndex);
    }
}

