/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.mobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.animal.ChickenMob;
import net.minecraft.core.entity.animal.CowMob;
import net.minecraft.core.entity.animal.FireflyClusterMob;
import net.minecraft.core.entity.animal.PigMob;
import net.minecraft.core.entity.animal.SheepMob;
import net.minecraft.core.entity.animal.SquidMob;
import net.minecraft.core.entity.animal.WolfMob;
import net.minecraft.core.entity.monster.CreeperMob;
import net.minecraft.core.entity.monster.GhastMob;
import net.minecraft.core.entity.monster.SkeletonMob;
import net.minecraft.core.entity.monster.SlimeMob;
import net.minecraft.core.entity.monster.SnowmanMob;
import net.minecraft.core.entity.monster.SpiderMob;
import net.minecraft.core.entity.monster.ZombieArmoredMob;
import net.minecraft.core.entity.monster.ZombieMob;
import net.minecraft.core.entity.monster.ZombiePigMob;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;

public abstract class MobInfoRegistry {
    private static final Map<Class<? extends Entity>, MobInfo> mobInfoMap = new HashMap<Class<? extends Entity>, MobInfo>();
    private static final List<Class<? extends Entity>> mobClassList = new ArrayList<Class<? extends Entity>>();

    public static void register(Class<? extends Entity> entityClass, String nameTranslationKey, String descriptionTranslationKey, int health, int score, MobDrop[] drops) {
        mobClassList.add(entityClass);
        mobInfoMap.put(entityClass, new MobInfo(entityClass, nameTranslationKey, descriptionTranslationKey, health, score, drops));
    }

    public static List<Class<? extends Entity>> getMobClassList() {
        return Collections.unmodifiableList(mobClassList);
    }

    public static MobInfo getMobInfo(Class<? extends Entity> entityClass) {
        return mobInfoMap.get(entityClass);
    }

    static {
        MobInfoRegistry.register(PigMob.class, "guidebook.section.mob.pig.name", "guidebook.section.mob.pig.desc", 10, 10, new MobDrop[]{new MobDrop(new ItemStack(Items.FOOD_PORKCHOP_RAW), 1.0f, 1, 2)});
        MobInfoRegistry.register(SheepMob.class, "guidebook.section.mob.sheep.name", "guidebook.section.mob.sheep.desc", 10, 10, new MobDrop[]{new MobDrop(new ItemStack(Blocks.WOOL), 1.0f, 1, 1)});
        MobInfoRegistry.register(CowMob.class, "guidebook.section.mob.cow.name", "guidebook.section.mob.cow.desc", 10, 10, new MobDrop[]{new MobDrop(new ItemStack(Items.LEATHER), 1.0f, 1, 5)});
        MobInfoRegistry.register(ChickenMob.class, "guidebook.section.mob.chicken.name", "guidebook.section.mob.chicken.desc", 4, 10, new MobDrop[]{new MobDrop(new ItemStack(Items.FEATHER_CHICKEN), 0.66f, 1, 2)});
        MobInfoRegistry.register(SquidMob.class, "guidebook.section.mob.squid.name", "guidebook.section.mob.squid.desc", 10, 10, new MobDrop[]{new MobDrop(new ItemStack(Items.DYE, 1, 0), 1.0f, 1, 3)});
        MobInfoRegistry.register(WolfMob.class, "guidebook.section.mob.wolf.name", "guidebook.section.mob.wolf.desc", 8, 500, null);
        MobInfoRegistry.register(FireflyClusterMob.class, "guidebook.section.mob.firefly_cluster.name", "guidebook.section.mob.firefly_cluster.desc", -1, -1, null);
        MobInfoRegistry.register(ZombieMob.class, "guidebook.section.mob.zombie.name", "guidebook.section.mob.zombie.desc", 20, 300, new MobDrop[]{new MobDrop(new ItemStack(Items.CLOTH), 0.66f, 1, 2)});
        MobInfoRegistry.register(ZombieArmoredMob.class, "guidebook.section.mob.armored_zombie.name", "guidebook.section.mob.armored_zombie.desc", 40, 1000, new MobDrop[]{new MobDrop(new ItemStack(Items.CLOTH), 1.0f, 1, 2), new MobDrop(new ItemStack(Items.CHAINLINK), 0.8f, 1, 4)});
        MobInfoRegistry.register(SnowmanMob.class, "guidebook.section.mob.snowman.name", "guidebook.section.mob.snowman.desc", 20, 300, new MobDrop[]{new MobDrop(new ItemStack(Items.AMMO_SNOWBALL), 0.66f, 1, 2)});
        MobInfoRegistry.register(CreeperMob.class, "guidebook.section.mob.creeper.name", "guidebook.section.mob.creeper.desc", 20, 800, new MobDrop[]{new MobDrop(new ItemStack(Items.SULPHUR), 0.66f, 1, 2)});
        MobInfoRegistry.register(SkeletonMob.class, "guidebook.section.mob.skeleton.name", "guidebook.section.mob.skeleton.desc", 20, 500, new MobDrop[]{new MobDrop(new ItemStack(Items.BONE), 0.66f, 1, 2), new MobDrop(new ItemStack(Items.AMMO_ARROW), 0.66f, 1, 2)});
        MobInfoRegistry.register(SpiderMob.class, "guidebook.section.mob.spider.name", "guidebook.section.mob.spider.desc", 20, 200, new MobDrop[]{new MobDrop(new ItemStack(Items.STRING), 0.66f, 1, 2)});
        MobInfoRegistry.register(SlimeMob.class, "guidebook.section.mob.slime.name", "guidebook.section.mob.slime.desc", -1, 100, new MobDrop[]{new MobDrop(new ItemStack(Items.SLIMEBALL), 0.66f, 1, 2)});
        MobInfoRegistry.register(GhastMob.class, "guidebook.section.mob.ghast.name", "guidebook.section.mob.ghast.desc", 20, 1000, new MobDrop[]{new MobDrop(new ItemStack(Items.SULPHUR), 0.66f, 1, 2)});
        MobInfoRegistry.register(ZombiePigMob.class, "guidebook.section.mob.zombie_pigman.name", "guidebook.section.mob.zombie_pigman.desc", 20, 500, new MobDrop[]{new MobDrop(new ItemStack(Items.FOOD_PORKCHOP_RAW), 0.297f, 1, 2), new MobDrop(new ItemStack(Items.ORE_RAW_GOLD), 0.0264f, 1, 2), new MobDrop(new ItemStack(Items.TOOL_SWORD_GOLD), 0.0066f, 1, 1)});
    }

    public static class MobInfo {
        private final Class<? extends Entity> entityClass;
        private final String nameTranslationKey;
        private final String descriptionTranslationKey;
        private final int health;
        private final int score;
        private final MobDrop[] drops;

        public MobInfo(Class<? extends Entity> entityClass, String nameTranslationKey, String descriptionTranslationKey, int health, int score, MobDrop[] drops) {
            this.entityClass = entityClass;
            this.nameTranslationKey = nameTranslationKey;
            this.descriptionTranslationKey = descriptionTranslationKey;
            this.health = health;
            this.score = score;
            this.drops = drops;
        }

        public Class<?> getEntityClass() {
            return this.entityClass;
        }

        public EntityRenderer<?> getRenderer() {
            return EntityRenderDispatcher.instance.getRenderer(this.entityClass);
        }

        public String getNameTranslationKey() {
            return this.nameTranslationKey;
        }

        public String getDescriptionTranslationKey() {
            return this.descriptionTranslationKey;
        }

        public int getHealth() {
            return this.health;
        }

        public int getScore() {
            return this.score;
        }

        public MobDrop[] getDrops() {
            return this.drops;
        }
    }

    public static class MobDrop {
        private final ItemStack dropStack;
        private final float dropChance;
        private final int minAmount;
        private final int maxAmount;

        public MobDrop(ItemStack dropStack, float dropChance, int minAmount, int maxAmount) {
            this.dropStack = dropStack;
            this.dropChance = dropChance;
            this.minAmount = minAmount;
            this.maxAmount = maxAmount;
        }

        public ItemStack getStack() {
            return this.dropStack;
        }

        public float getChance() {
            return this.dropChance;
        }

        public int getMinAmount() {
            return this.minAmount;
        }

        public int getMaxAmount() {
            return this.maxAmount;
        }
    }
}

